/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.widgets.realtime;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.connection.dnd.ItemTransfer;
import org.eclipse.scada.da.ui.widgets.realtime.ListEntry;
import org.eclipse.scada.da.ui.widgets.realtime.Messages;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.URLTransfer;

public class RealtimeListDragSourceListener
implements DragSourceListener {
    private Viewer viewer = null;

    public RealtimeListDragSourceListener(Viewer viewer) {
        this.viewer = viewer;
    }

    public void dragFinished(DragSourceEvent event) {
    }

    public void dragSetData(DragSourceEvent event) {
        try {
            IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
            if (ItemTransfer.getInstance().isSupportedType(event.dataType)) {
                ArrayList<Item> items = new ArrayList<Item>();
                for (ListEntry entry : selection) {
                    items.add(entry.getItem());
                }
                event.data = items.toArray(new Item[items.size()]);
            } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                this.setItemUriData(event, selection);
            } else if (URLTransfer.getInstance().isSupportedType(event.dataType)) {
                this.setItemUriData(event, selection);
            }
        }
        catch (Exception exception) {
            event.doit = false;
        }
    }

    protected void setItemUriData(DragSourceEvent event, IStructuredSelection selection) {
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        for (ListEntry entry : selection) {
            Item item;
            if (cnt > 0) {
                sb.append("\n");
            }
            if ((item = entry.getItem()).getType() != Item.Type.URI) {
                throw new IllegalStateException(Messages.RealtimeListDragSourceListener_TypeError);
            }
            sb.append(item.getConnectionString());
            sb.append("#");
            try {
                sb.append(URLEncoder.encode(item.getId(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                sb.append(item.getId());
            }
            ++cnt;
        }
        event.data = sb.toString();
    }

    protected void setItemStringData(DragSourceEvent event, IStructuredSelection selection) {
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        for (ListEntry entry : selection) {
            if (cnt > 0) {
                sb.append("\n");
            }
            sb.append(entry.getDataItem().getItem().getId());
            ++cnt;
        }
        event.data = sb.toString();
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = false;
        if (!(this.viewer.getSelection() instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        for (Object o : selection) {
            if (o instanceof ListEntry) continue;
            return;
        }
        LocalSelectionTransfer.getTransfer().setSelection(this.viewer.getSelection());
        event.doit = true;
    }
}

