/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.ca.client.Connection;
import org.eclipse.scada.ca.data.ConfigurationInformation;
import org.eclipse.scada.ca.data.FactoryInformation;
import org.eclipse.scada.ca.ui.util.Messages;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class ConfigurationHelper {
    public static Collection<FactoryInformation> loadData(IProgressMonitor monitor, Connection connection) throws InterruptedException, ExecutionException {
        LinkedList<FactoryInformation> result = new LinkedList<FactoryInformation>();
        try {
            NotifyFuture future = connection.getFactories();
            FactoryInformation[] factories = (FactoryInformation[])future.get();
            monitor.beginTask(Messages.ConfigurationHelper_TaskName, factories.length);
            FactoryInformation[] factoryInformationArray = factories;
            int n = factories.length;
            int n2 = 0;
            while (n2 < n) {
                FactoryInformation factory = factoryInformationArray[n2];
                monitor.subTask(String.format(Messages.ConfigurationHelper_SubTaskNameFormat, factory.getId()));
                result.add((FactoryInformation)connection.getFactoryWithData(factory.getId()).get());
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    return null;
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    public static long convert(Collection<FactoryInformation> remoteData, Map<String, Map<String, Map<String, String>>> data) {
        long count = 0L;
        for (FactoryInformation factory : remoteData) {
            HashMap<String, Map> factoryData = new HashMap<String, Map>();
            data.put(factory.getId(), factoryData);
            if (factory.getConfigurations() == null) continue;
            for (ConfigurationInformation configuration : factory.getConfigurations()) {
                factoryData.put(configuration.getId(), configuration.getData());
                ++count;
            }
        }
        return count;
    }

    public static Map<String, Map<String, Map<String, String>>> convert(Collection<FactoryInformation> remoteData) {
        HashMap<String, Map<String, Map<String, String>>> data = new HashMap<String, Map<String, Map<String, String>>>();
        ConfigurationHelper.convert(remoteData, data);
        return data;
    }
}

