/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.views.tree.node;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.scada.core.ui.connection.ConnectionDescriptor;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;
import org.eclipse.scada.core.ui.connection.views.tree.ConnectionPoolManager;
import org.eclipse.scada.core.ui.connection.views.tree.node.GroupChildNode;
import org.eclipse.scada.core.ui.connection.views.tree.node.GroupingProvider;

public class GroupingNode
extends GroupChildNode {
    private final ISetChangeListener listener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            GroupingNode.this.handleDiff(event.diff);
        }
    };
    private final ConnectionPoolManager poolManager;
    private final GroupingProvider groupingProvider;
    private final Map<ConnectionDescriptor, List<String>> pathMap = new HashMap<ConnectionDescriptor, List<String>>();

    public GroupingNode(Realm realm, String name, ConnectionPoolManager poolManager, GroupingProvider groupingProvider) {
        super(realm, name, null);
        this.poolManager = poolManager;
        this.groupingProvider = groupingProvider;
        poolManager.getAllConnections().addSetChangeListener(this.listener);
    }

    @Override
    public void dispose() {
        this.poolManager.getAllConnections().removeSetChangeListener(this.listener);
        super.dispose();
    }

    protected void handleDiff(SetDiff diff) {
        List<String> path;
        ConnectionDescriptor desc;
        ConnectionHolder holder;
        for (Object o : diff.getAdditions()) {
            holder = (ConnectionHolder)((Object)o);
            desc = holder.getConnectionInformation();
            path = this.makePath(desc);
            this.addPath(new LinkedList<String>(path), holder);
            this.pathMap.put(desc, path);
        }
        for (Object o : diff.getRemovals()) {
            holder = (ConnectionHolder)((Object)o);
            desc = holder.getConnectionInformation();
            path = this.pathMap.get(desc);
            if (path == null) continue;
            this.removePath(path, holder);
        }
    }

    private List<String> makePath(ConnectionDescriptor desc) {
        try {
            return this.groupingProvider.getGroups(desc);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }
}

