/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.scada.core.ui.connection.ConnectionDescriptor;
import org.eclipse.scada.core.ui.connection.ConnectionStore;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;
import org.eclipse.scada.core.ui.connection.wizards.AddConnectionWizardPage1;
import org.eclipse.scada.ui.databinding.AdapterHelper;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddConnectionWizard
extends Wizard
implements INewWizard {
    private static final Logger logger = LoggerFactory.getLogger(AddConnectionWizard.class);
    private AddConnectionWizardPage1 entryPage;
    private ConnectionStore store;
    private ConnectionDescriptor preset;

    protected boolean isUpdateMode() {
        return false;
    }

    public boolean performFinish() {
        ConnectionDescriptor connectionInformation = this.entryPage.getConnectionInformation();
        try {
            if (connectionInformation != null) {
                if (this.isUpdateMode()) {
                    this.store.update(this.preset, connectionInformation);
                } else {
                    this.store.add(connectionInformation);
                }
            }
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e.getStatus(), 4);
            return false;
        }
        return connectionInformation != null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object o = selection.getFirstElement();
        if (o == null) {
            return;
        }
        this.store = (ConnectionStore)AdapterHelper.adapt((Object)o, ConnectionStore.class);
        logger.info("Store is: {}", (Object)this.store);
        ConnectionHolder holder = (ConnectionHolder)((Object)AdapterHelper.adapt((Object)o, ConnectionHolder.class));
        if (holder != null) {
            if (this.store == null) {
                this.store = (ConnectionStore)AdapterHelper.adapt((Object)holder.getDiscoverer(), ConnectionStore.class);
            }
            this.preset = holder.getConnectionInformation();
        }
        logger.info("Preset is: {}", (Object)this.preset);
    }

    public boolean canFinish() {
        return this.store != null;
    }

    public void addPages() {
        super.addPages();
        this.entryPage = new AddConnectionWizardPage1(this.preset);
        this.addPage((IWizardPage)this.entryPage);
    }
}

