/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.login;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.scada.core.ui.connection.login.LoginContext;
import org.eclipse.scada.core.ui.connection.login.LoginFactory;
import org.eclipse.scada.core.ui.connection.login.LoginHandler;
import org.eclipse.scada.core.ui.connection.login.LoginSession;
import org.eclipse.scada.core.ui.connection.login.Messages;
import org.eclipse.scada.core.ui.connection.login.SessionManager;
import org.eclipse.scada.core.ui.connection.login.internal.SessionManagerImpl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.scada.core.ui.connection.login";
    private static Activator plugin;
    private SessionManager sessionManager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.sessionManager = new SessionManagerImpl(SWTObservables.getRealm((Display)this.getWorkbench().getDisplay()));
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.sessionManager.getRealm().exec(new Runnable(){

            @Override
            public void run() {
                Activator.this.sessionManager.dispose();
                Activator.this.sessionManager = null;
            }
        });
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public LoginContext[] getContextList() {
        LinkedList<LoginContext> result = new LinkedList<LoginContext>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.scada.core.ui.connection.login.context");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            if ("context".equals(ele.getName())) {
                String name = ele.getAttribute("label");
                String id = ele.getAttribute("id");
                HashMap<String, String> properties = new HashMap<String, String>();
                IConfigurationElement[] iConfigurationElementArray2 = ele.getChildren("property");
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement child = iConfigurationElementArray2[n4];
                    String key = child.getAttribute("key");
                    String value = child.getAttribute("value");
                    if (key != null && value != null) {
                        properties.put(key, value);
                    }
                    ++n4;
                }
                LinkedList<LoginFactory> factories = new LinkedList<LoginFactory>();
                this.fillFactories(factories, ele);
                if (id != null && name != null && !factories.isEmpty()) {
                    result.add(new LoginContext(id, name, factories, properties));
                }
            }
            ++n2;
        }
        return result.toArray(new LoginContext[result.size()]);
    }

    private void fillFactories(Collection<LoginFactory> factories, IConfigurationElement ele) {
        IConfigurationElement[] iConfigurationElementArray = ele.getChildren("factory");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            try {
                LoginFactory factory = (LoginFactory)child.createExecutableExtension("class");
                if (factory != null) {
                    factories.add(factory);
                }
            }
            catch (Exception e) {
                this.getLog().log((IStatus)new Status(2, PLUGIN_ID, Messages.Activator_ErrorParse, (Throwable)e));
            }
            ++n2;
        }
    }

    public synchronized void setLoginSession(LoginSession session) {
        this.sessionManager.setSession(session);
    }

    public void setLoginSession(String username, String password, LoginContext loginContext, Collection<LoginHandler> handler) {
        this.setLoginSession(new LoginSession(this.getBundle().getBundleContext(), username, password, loginContext, handler));
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }
}

