/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.login.dialog;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scada.core.ui.connection.login.Activator;
import org.eclipse.scada.core.ui.connection.login.LoginContext;
import org.eclipse.scada.core.ui.connection.login.LoginHandler;
import org.eclipse.scada.core.ui.connection.login.dialog.ConnectionAnalyzer;
import org.eclipse.scada.core.ui.connection.login.dialog.ContextCreator;
import org.eclipse.scada.core.ui.connection.login.dialog.ContextCreatorResultListener;
import org.eclipse.scada.core.ui.connection.login.dialog.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginDialog
extends TitleAreaDialog {
    private static final String SETTING_AS_PROPERTIES = "transmitCredentialsAsProperties";
    private static final String SETTING_USER = "user";
    private static final String SETTING_CONTEXT = "context";
    private static final Logger logger = LoggerFactory.getLogger(LoginDialog.class);
    private ComboViewer contextSelector;
    private Text userText;
    private Text passwordText;
    private final LoginContext[] contexts;
    private LoginContext loginContext;
    private ConnectionAnalyzer analyzer;
    private ContextCreator creator;
    private String user;
    private String password;
    private final IDialogSettings dialogSettings;
    private boolean flagCredentialsAsProperties;

    public LoginDialog(Shell parentShell) {
        super(parentShell);
        this.setBlockOnOpen(true);
        this.setTitle(Messages.LoginDialog_Dlg_Title);
        this.setHelpAvailable(false);
        this.contexts = Activator.getDefault().getContextList();
        this.dialogSettings = this.getDialogSection();
    }

    private IDialogSettings getDialogSection() {
        IDialogSettings section = Activator.getDefault().getDialogSettings().getSection("LoginDialog");
        if (section == null) {
            section = Activator.getDefault().getDialogSettings().addNewSection("LoginDialog");
        }
        return section;
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveTo() {
        if (this.loginContext != null && this.user != null) {
            this.dialogSettings.put(SETTING_CONTEXT, this.loginContext.getId());
            this.dialogSettings.put(SETTING_USER, this.user);
            this.dialogSettings.put(SETTING_AS_PROPERTIES, this.flagCredentialsAsProperties);
        }
    }

    private void loadFrom() {
        this.flagCredentialsAsProperties = this.dialogSettings.getBoolean(SETTING_AS_PROPERTIES);
        String user = this.dialogSettings.get(SETTING_USER);
        String contextId = this.dialogSettings.get(SETTING_CONTEXT);
        if (user != null && contextId != null) {
            this.userText.setText(user);
            LoginContext[] loginContextArray = this.contexts;
            int n = this.contexts.length;
            int n2 = 0;
            while (n2 < n) {
                LoginContext context = loginContextArray[n2];
                if (context.getId().equals(contextId)) {
                    this.contextSelector.setSelection((ISelection)new StructuredSelection((Object)context), true);
                }
                ++n2;
            }
            this.passwordText.setFocus();
        } else {
            this.contextSelector.getControl().setFocus();
        }
    }

    private void update() {
        Button button = this.getButton(0);
        try {
            this.setMessage(Messages.LoginDialog_DefaultMessage, 1);
            this.validate();
            button.setEnabled(true);
        }
        catch (Exception e) {
            button.setEnabled(false);
            this.setMessage(e.getMessage(), 3);
        }
    }

    private void validate() {
        Object o;
        this.user = this.userText.getText();
        this.password = this.passwordText.getText();
        this.loginContext = null;
        ISelection sel = this.contextSelector.getSelection();
        if (sel instanceof IStructuredSelection && !((IStructuredSelection)sel).isEmpty() && (o = ((IStructuredSelection)sel).getFirstElement()) instanceof LoginContext) {
            this.loginContext = (LoginContext)o;
        }
        if (this.loginContext == null) {
            throw new IllegalStateException(Messages.LoginDialog_Error_NoLoginContext);
        }
        if (this.password == null || this.password.length() == 0) {
            this.password = null;
            this.setMessage(Messages.LoginDialog_Message_EmptyPassword, 2);
        }
        if (this.user == null || this.user.length() == 0) {
            this.user = null;
            this.setMessage(Messages.LoginDialog_Message_EmptyUsername, 2);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.LoginDialog_Shell_Text);
    }

    protected Control createDialogArea(Composite parent) {
        Composite wrapper = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)wrapper);
        Composite contents = this.createComposite(wrapper);
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        Dialog.applyDialogFont((Control)wrapper);
        this.setTitle(Messages.LoginDialog_Dlg_Title);
        return wrapper;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.update();
        this.loadFrom();
        return control;
    }

    private Composite createComposite(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(contents, 0);
        label.setText(Messages.LoginDialog_Label_Context_Text);
        this.contextSelector = new ComboViewer(contents, 8);
        this.contextSelector.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.contextSelector.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                LoginContext ctx = (LoginContext)element;
                return ctx.getName();
            }
        });
        this.contextSelector.setInput((Object)this.contexts);
        this.applyLayout(this.contextSelector.getControl());
        this.contextSelector.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LoginDialog.this.update();
            }
        });
        label = new Label(contents, 0);
        label.setText(Messages.LoginDialog_Label_User_Text);
        this.userText = new Text(contents, 2048);
        this.userText.setMessage(Messages.LoginDialog_Text_User_Message);
        this.applyLayout((Control)this.userText);
        this.userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoginDialog.this.update();
            }
        });
        label = new Label(contents, 0);
        label.setText(Messages.LoginDialog_Label_Password_Text);
        this.passwordText = new Text(contents, 0x400800);
        this.passwordText.setMessage(Messages.LoginDialog_Text_Password_Message);
        this.applyLayout((Control)this.passwordText);
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoginDialog.this.update();
            }
        });
        final Button adv = new Button(contents, 32);
        adv.setText(Messages.LoginDialog_AdvancedButton_Text);
        adv.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoginDialog.this.toggleAdvanced(adv.getSelection());
            }
        });
        adv.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.analyzer = new ConnectionAnalyzer(contents, 0);
        this.analyzer.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.analyzer.setBackground(Display.getCurrent().getSystemColor(3));
        return contents;
    }

    protected void toggleAdvanced(boolean selection) {
        if (selection) {
            this.openTray(new DialogTray(){

                protected Control createContents(Composite parent) {
                    return LoginDialog.this.createAdvancedContent(parent);
                }
            });
        } else {
            this.closeTray();
        }
    }

    private Composite createAdvancedContent(Composite advWrapper) {
        Composite advContent = new Composite(advWrapper, 0);
        advContent.setLayout((Layout)new GridLayout(1, false));
        final Button credentialsAsProperties = new Button(advContent, 32);
        credentialsAsProperties.setText(Messages.LoginDialog_CredentialsButtons_Text);
        credentialsAsProperties.setToolTipText(Messages.LoginDialog_CredentialsButtons_ToolTip);
        credentialsAsProperties.setSelection(this.flagCredentialsAsProperties);
        credentialsAsProperties.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoginDialog.this.flagCredentialsAsProperties = credentialsAsProperties.getSelection();
            }
        });
        return advContent;
    }

    private void applyLayout(Control control) {
        control.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    protected void okPressed() {
        this.startLogin(this.loginContext);
    }

    private void startLogin(LoginContext loginContext) {
        if (this.creator != null) {
            logger.error("Found pre-existing creator instance. This should not happen!");
            this.creator.dispose();
            this.creator = null;
        }
        Button button = this.getButton(0);
        button.setEnabled(false);
        this.contextSelector.getControl().setEnabled(false);
        this.userText.setEnabled(false);
        this.passwordText.setEnabled(false);
        if (this.getTray() != null) {
            this.closeTray();
        }
        this.analyzer.clear();
        Realm realm = SWTObservables.getRealm((Display)this.getShell().getDisplay());
        this.creator = new ContextCreator(realm, loginContext, this.analyzer, new ContextCreatorResultListener(){

            @Override
            public void complete(Collection<LoginHandler> result) {
                LoginDialog.this.handleComplete(result);
            }
        });
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.flagCredentialsAsProperties) {
            properties.put("credentialsAsProperties", "true");
        }
        this.creator.start(this.userText.getText(), this.passwordText.getText(), properties);
    }

    protected void handleComplete(Collection<LoginHandler> result) {
        if (this.creator == null) {
            logger.error("Creating is null but we got a result. This should also never happen!");
            return;
        }
        this.creator.dispose();
        this.creator = null;
        if (result == null) {
            Button button = this.getButton(0);
            button.setEnabled(true);
            this.contextSelector.getControl().setEnabled(true);
            this.userText.setEnabled(true);
            this.passwordText.setEnabled(true);
        } else {
            this.saveTo();
            Activator.getDefault().setLoginSession(this.user, this.password, this.loginContext, result);
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        if (this.creator != null) {
            this.creator.dispose();
            this.creator = null;
        } else {
            super.cancelPressed();
        }
    }
}

