/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.databinding.item;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.scada.core.connection.provider.ConnectionIdTracker;
import org.eclipse.scada.core.connection.provider.ConnectionTracker;
import org.eclipse.scada.da.client.DataItem;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.client.ItemManager;
import org.eclipse.scada.da.connection.provider.ConnectionService;
import org.eclipse.scada.ui.databinding.item.InvalidValuePolicy;
import org.osgi.framework.BundleContext;

public class DataItemObservableValue
extends AbstractObservableValue {
    public static final InvalidValuePolicy VALUE_POLICY_REPLACE_DISCONNECTED = new ReplaceInvalidValuePolicy(DataItemValue.DISCONNECTED);
    public static final InvalidValuePolicy VALUE_POLICY_IGNORE = new InvalidValuePolicy(){

        @Override
        public boolean isInvalid(DataItemValue value) {
            return false;
        }

        @Override
        public DataItemValue processInvalid(DataItemValue value) {
            return value;
        }
    };
    private final ConnectionTracker tracker;
    private DataItemValue value = DataItemValue.DISCONNECTED;
    private DataItem dataItem;
    private String itemId;
    private Observer observer;
    private ConnectionService service;
    private final InvalidValuePolicy invalidValuePolicy;

    public DataItemObservableValue(BundleContext context, String connectionId, String itemId) {
        this(context, connectionId, itemId, VALUE_POLICY_REPLACE_DISCONNECTED, Realm.getDefault());
    }

    public DataItemObservableValue(BundleContext context, String connectionId, String itemId, Realm realm) {
        this(context, connectionId, itemId, VALUE_POLICY_REPLACE_DISCONNECTED, realm);
    }

    public DataItemObservableValue(BundleContext context, String connectionId, String itemId, InvalidValuePolicy invalidValuePolicy) {
        this(context, connectionId, itemId, invalidValuePolicy, Realm.getDefault());
    }

    public DataItemObservableValue(BundleContext context, String connectionId, String itemId, InvalidValuePolicy invalidValuePolicy, Realm realm) {
        super(realm);
        this.invalidValuePolicy = invalidValuePolicy;
        this.itemId = itemId;
        ConnectionTracker.Listener listener = new ConnectionTracker.Listener(){

            public void setConnection(org.eclipse.scada.core.connection.provider.ConnectionService connectionService) {
                DataItemObservableValue.this.bind(connectionService);
            }
        };
        this.tracker = new ConnectionIdTracker(context, connectionId, listener, ConnectionService.class);
        this.tracker.open();
    }

    protected synchronized void bind(org.eclipse.scada.core.connection.provider.ConnectionService connectionService) {
        this.unbind();
        this.service = null;
        if (connectionService instanceof ConnectionService) {
            this.service = (ConnectionService)connectionService;
            this.bind();
        }
    }

    private void bind() {
        if (this.service != null && this.itemId != null) {
            ItemManager im = this.service.getItemManager();
            this.dataItem = new DataItem(this.itemId);
            this.observer = this.createObserver();
            this.dataItem.addObserver(this.observer);
            this.dataItem.register(im);
        }
    }

    private Observer createObserver() {
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (arg instanceof DataItemValue) {
                    DataItemObservableValue.this.handleUpdate(this, (DataItemValue)arg);
                }
            }
        };
    }

    protected synchronized void handleUpdate(Observer observer, DataItemValue value) {
        if (observer != this.observer) {
            return;
        }
        if (this.invalidValuePolicy.isInvalid(value)) {
            value = this.invalidValuePolicy.processInvalid(value);
        }
        this.value = value;
        this.fireChange(this.value, this.value);
    }

    private void fireChange(final DataItemValue oldValue, final DataItemValue newValue) {
        final ValueDiff diff = new ValueDiff(){

            public Object getOldValue() {
                return oldValue;
            }

            public Object getNewValue() {
                return newValue;
            }
        };
        this.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                DataItemObservableValue.this.fireValueChange(diff);
            }
        });
    }

    protected synchronized void unbind() {
        this.observer = null;
        if (this.dataItem != null) {
            this.dataItem.unregister();
            this.dataItem.deleteObservers();
            this.handleUpdate(null, DataItemValue.DISCONNECTED);
        }
    }

    public synchronized void dispose() {
        this.service = null;
        this.tracker.close();
        this.unbind();
        super.dispose();
    }

    public Object getValueType() {
        return DataItemValue.class;
    }

    protected Object doGetValue() {
        return this.value;
    }

    public String getItemId() {
        return this.itemId;
    }

    public synchronized void setItemId(String itemId) {
        if (this.itemId == null && itemId == null) {
            return;
        }
        if (this.itemId != null && this.itemId.equals(itemId)) {
            return;
        }
        this.unbind();
        this.itemId = itemId;
        this.bind();
        if (itemId == null) {
            this.handleUpdate(this.observer, DataItemValue.DISCONNECTED);
        }
    }

    public static final class ReplaceInvalidValuePolicy
    implements InvalidValuePolicy {
        private final DataItemValue replacement;

        public ReplaceInvalidValuePolicy(DataItemValue replacement) {
            this.replacement = replacement;
        }

        @Override
        public boolean isInvalid(DataItemValue value) {
            if (value == null) {
                return true;
            }
            return !value.isConnected() || value.isError();
        }

        @Override
        public DataItemValue processInvalid(DataItemValue value) {
            return this.replacement;
        }
    }
}

