/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.ui.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.hd.Query;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.client.Connection;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.data.ValueInformation;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractQueryBuffer
extends AbstractPropertyChange {
    private static final Logger logger = LoggerFactory.getLogger(AbstractQueryBuffer.class);
    public static final String PROP_STATE = "state";
    public static final String PROP_QUERY_PARAMETERS = "queryParameters";
    public static final String PROP_REQUEST_PARAMETERS = "requestParameters";
    public static final String PROP_VALUE_TYPES = "valueTypes";
    public static final String PROP_FILLED = "filled";
    public static final String PROP_PERCENT_FILLED = "percentFilled";
    protected final Set<QueryListener> listeners = new HashSet<QueryListener>();
    protected final String itemId;
    private QueryParameters requestParameters;
    private QueryParameters queryParameters;
    protected Query query;
    private QueryState state;
    private Set<String> valueTypes;
    private List<ValueInformation> valueInformation;
    private HashMap<String, List<Double>> values;
    private int filled;
    private double percentFilled;
    private Double lastFilled;
    private static double FILLED_DELTA = 1.0;

    public AbstractQueryBuffer(String itemId) {
        this.itemId = itemId;
    }

    public QueryState getState() {
        return this.state;
    }

    public String getItemId() {
        return this.itemId;
    }

    public QueryParameters getRequestParameters() {
        return this.requestParameters;
    }

    public QueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    public Set<String> getValueTypes() {
        return this.valueTypes;
    }

    public int getFilled() {
        return this.filled;
    }

    public double getPercentFilled() {
        return this.percentFilled;
    }

    public List<ValueInformation> getValueInformation() {
        return this.valueInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<Double>> getValues() {
        HashMap<String, List<Double>> values;
        AbstractQueryBuffer abstractQueryBuffer = this;
        synchronized (abstractQueryBuffer) {
            block4: {
                values = this.values;
                if (values != null) break block4;
                return null;
            }
        }
        return new HashMap<String, List<Double>>(values);
    }

    protected synchronized void updateData(int index, Map<String, List<Double>> values, List<ValueInformation> valueInformation) {
        int count = valueInformation.size();
        int filled = this.filled;
        int i = 0;
        while (i < count) {
            if (this.valueInformation.get(i + index) == null) {
                ++filled;
            }
            this.valueInformation.set(i + index, valueInformation.get(i));
            ++i;
        }
        for (String type : this.valueTypes) {
            List<Double> src = values.get(type);
            List<Double> dst = this.values.get(type);
            List<Double> sub = dst.subList(index, index + count);
            sub.clear();
            sub.addAll(src);
        }
        this.setFilled(filled);
        this.fireDataChange(index, values, valueInformation);
    }

    private void setFilled(int filled) {
        int oldFilled = this.filled;
        this.filled = filled;
        this.firePropertyChange(PROP_FILLED, oldFilled, filled);
        double percentFilled = (double)filled / (double)this.queryParameters.getNumberOfEntries();
        this.setPercentFilled(percentFilled);
    }

    private void setPercentFilled(double percentFilled) {
        double oldPercentFilled = this.percentFilled;
        this.percentFilled = percentFilled;
        if (this.lastFilled == null || Math.abs(this.lastFilled - percentFilled) > FILLED_DELTA) {
            this.lastFilled = percentFilled;
            this.firePropertyChange(PROP_PERCENT_FILLED, oldPercentFilled, percentFilled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateParameters(QueryParameters parameters, Set<String> valueTypes) {
        logger.info("Update parameters - queryParameters: {}, valueTypeS: {}", (Object)parameters, valueTypes);
        int count = parameters.getNumberOfEntries();
        ArrayList<ValueInformation> newValueInformation = new ArrayList<ValueInformation>(Arrays.asList(new ValueInformation[count]));
        HashMap<String, ArrayList<Double>> newValues = new HashMap<String, ArrayList<Double>>();
        for (String valueType : valueTypes) {
            newValues.put(valueType, new ArrayList<Double>(Arrays.asList(new Double[count])));
        }
        AbstractQueryBuffer abstractQueryBuffer = this;
        synchronized (abstractQueryBuffer) {
            this.valueInformation = newValueInformation;
            this.values = newValues;
            this.fireParameterChange(parameters, valueTypes);
            this.setQueryParameters(parameters);
            this.setValueTypes(valueTypes);
            this.setFilled(0);
        }
    }

    private void setValueTypes(Set<String> valueTypes) {
        logger.debug("Set value types: {}", valueTypes);
        Set<String> oldValueTypes = this.valueTypes;
        this.valueTypes = valueTypes;
        this.firePropertyChange(PROP_VALUE_TYPES, oldValueTypes, valueTypes);
    }

    private void setQueryParameters(QueryParameters parameters) {
        QueryParameters oldParameters = this.queryParameters;
        this.queryParameters = parameters;
        this.firePropertyChange(PROP_QUERY_PARAMETERS, oldParameters, parameters);
    }

    protected void setRequestParameters(QueryParameters parameters) {
        logger.debug("Setting request parameters: {}", (Object)parameters);
        QueryParameters oldParameters = this.requestParameters;
        this.requestParameters = parameters;
        this.firePropertyChange(PROP_REQUEST_PARAMETERS, oldParameters, parameters);
    }

    protected synchronized void updateState(QueryState state) {
        QueryState oldState = this.state;
        this.state = state;
        this.fireStateChange(state);
        this.firePropertyChange(PROP_STATE, oldState, state);
    }

    private void fireDataChange(int index, Map<String, List<Double>> values, List<ValueInformation> valueInformation) {
        for (QueryListener listener : this.listeners) {
            listener.updateData(index, values, valueInformation);
        }
    }

    private void fireParameterChange(QueryParameters parameters, Set<String> valueTypes) {
        for (QueryListener listener : this.listeners) {
            listener.updateParameters(parameters, valueTypes);
        }
    }

    private void fireStateChange(QueryState state) {
        for (QueryListener listener : this.listeners) {
            listener.updateState(state);
        }
    }

    public void close() {
        this.closeQuery();
    }

    protected void closeQuery() {
        if (this.query != null) {
            this.query.close();
            this.query = null;
        }
    }

    public synchronized void changeProperties(QueryParameters parameters) {
        logger.info("Request parameter change - new: {}, old: {}", new Object[]{parameters, this.requestParameters});
        if (!this.requestParameters.equals(parameters)) {
            this.setRequestParameters(parameters);
            if (this.query != null) {
                this.query.changeParameters(parameters);
            }
        } else {
            logger.info("Ignore change request since there is no change");
        }
    }

    public synchronized void addQueryListener(QueryListener listener) {
        if (!this.listeners.add(listener)) {
            return;
        }
        listener.updateState(this.state);
        if (this.queryParameters != null) {
            listener.updateParameters(this.queryParameters, this.valueTypes);
            this.transmitKnownData(listener);
        }
    }

    private void transmitKnownData(QueryListener listener) {
        if (this.valueInformation == null || this.valueInformation.size() == 0) {
            return;
        }
        int start = 0;
        int count = 0;
        int i = 0;
        while (i < this.valueInformation.size()) {
            if (this.valueInformation.get(i) == null) {
                if (count > 0) {
                    this.sendCache(listener, start, count);
                    count = 0;
                }
            } else {
                if (count == 0) {
                    start = i;
                }
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            this.sendCache(listener, start, count);
        }
    }

    private void sendCache(QueryListener listener, int start, int count) {
        logger.info("Sending cache: start: {} - count: {}", new Object[]{start, count});
        ArrayList<ValueInformation> info = new ArrayList<ValueInformation>(this.valueInformation.subList(start, start + count));
        HashMap<String, ArrayList<Double>> values = new HashMap<String, ArrayList<Double>>();
        for (String type : this.valueTypes) {
            List<Double> src = this.values.get(type);
            ArrayList<Double> dst = new ArrayList<Double>(src.subList(start, start + count));
            values.put(type, dst);
        }
        listener.updateData(start, this.values, info);
    }

    public synchronized void removeQueryListener(QueryListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void createQuery(Connection connection, String itemId) {
        this.closeQuery();
        this.query = connection.createQuery(itemId, this.requestParameters, new QueryListener(){

            public void updateState(QueryState state) {
                AbstractQueryBuffer.this.updateState(state);
            }

            public void updateParameters(QueryParameters parameters, Set<String> valueTypes) {
                AbstractQueryBuffer.this.updateParameters(parameters, valueTypes);
            }

            public void updateData(int index, Map<String, List<Double>> values, List<ValueInformation> valueInformation) {
                AbstractQueryBuffer.this.updateData(index, values, valueInformation);
            }
        }, true);
    }
}

