/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.data.SummaryListener;
import org.eclipse.scada.vi.data.SummaryProvider;

public class CompositeSummaryProvider
implements SummaryProvider,
SummaryListener {
    private final Set<SummaryListener> listeners = new CopyOnWriteArraySet<SummaryListener>();
    private SummaryInformation summaryInformation = new SummaryInformation(Collections.emptyMap());
    private final Set<SummaryProvider> providers = new CopyOnWriteArraySet<SummaryProvider>();

    public SummaryInformation getSummary() {
        return this.summaryInformation;
    }

    public void addSummaryListener(SummaryListener summaryListener) {
        if (this.listeners.add(summaryListener)) {
            summaryListener.summaryChanged(this.summaryInformation);
        }
    }

    public void removeSummaryListener(SummaryListener summaryListener) {
        this.listeners.remove(summaryListener);
    }

    public void dispose() {
        for (SummaryProvider provider : this.providers) {
            provider.removeSummaryListener((SummaryListener)this);
        }
        this.providers.clear();
    }

    public void addSummaryProvider(SummaryProvider summaryProvider) {
        if (summaryProvider == null) {
            return;
        }
        if (this.providers.add(summaryProvider)) {
            summaryProvider.addSummaryListener((SummaryListener)this);
        }
    }

    public void removeSummaryProvider(SummaryProvider summaryProvider) {
        if (this.providers.remove(summaryProvider)) {
            this.summaryChanged(null);
        }
    }

    public void summaryChanged(SummaryInformation summaryInformation) {
        this.fireChange(new SummaryInformation(Collections.emptyList(), Collections.emptyMap(), this.collect()));
    }

    private void fireChange(SummaryInformation summaryInformation) {
        this.summaryInformation = summaryInformation;
        for (SummaryListener listener : this.listeners) {
            listener.summaryChanged(summaryInformation);
        }
    }

    private Collection<SummaryInformation> collect() {
        LinkedList<SummaryInformation> result = new LinkedList<SummaryInformation>();
        for (SummaryProvider provider : this.providers) {
            result.add(provider.getSummary());
        }
        return result;
    }
}

