/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets;

import java.util.Map;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.details.swt.data.DataItemDescriptor;
import org.eclipse.scada.vi.details.swt.widgets.DescriptorLabel;
import org.eclipse.scada.vi.details.swt.widgets.Helper;
import org.eclipse.scada.vi.details.swt.widgets.ReadableComposite;
import org.eclipse.scada.vi.details.swt.widgets.control.ControlImage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressComposite
extends ReadableComposite {
    private static final Logger logger = LoggerFactory.getLogger(ProgressComposite.class);
    private final ProgressBar progressBar;
    private final Text text;
    private double max = 100.0;
    private double min = 0.0;
    private double factor = 1.0;
    private final int textWidth = 40;
    private final int textHeight = -1;
    private int width = 100;
    private int progressWidth;
    private final ControlImage controlImage;

    public ProgressComposite(Composite parent, int style, DataItemDescriptor descriptor, String format, String decimal, String attribute, double max, double min, double factor, int width, String hdConnectionId, String hdItemId, String queryString) {
        super(parent, style, format, decimal, false, attribute);
        if (max != 0.0) {
            this.max = max;
        }
        if (min != 0.0) {
            this.min = min;
        }
        if (factor != 0.0) {
            this.factor = factor;
        }
        if (width > 0) {
            this.width = width;
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ProgressComposite.this.handleDispose();
            }
        });
        RowLayout layout = new RowLayout();
        layout.wrap = false;
        layout.center = true;
        layout.spacing = 7;
        layout.pack = true;
        this.setLayout((Layout)layout);
        this.progressWidth = this.width - 40 - layout.spacing;
        if (this.progressWidth < 1) {
            this.progressWidth = 1;
        }
        this.controlImage = new ControlImage(this, this.registrationManager);
        Helper.createTrendButton(this.controlImage, hdConnectionId, hdItemId, queryString);
        this.progressBar = new ProgressBar((Composite)this, 0);
        RowData progressData = new RowData(this.progressWidth, -1);
        this.progressBar.setLayoutData((Object)progressData);
        int minimum = (int)Math.round(this.min);
        int maximum = (int)Math.round(this.max);
        this.progressBar.setMinimum(minimum);
        this.progressBar.setMaximum(maximum);
        this.text = new Text((Composite)this, 131138);
        RowData rowData = new RowData(40, -1);
        this.text.setLayoutData((Object)rowData);
        this.text.setEnabled(true);
        this.text.setEditable(false);
        this.text.setText("");
        new DescriptorLabel(this, 0, format, descriptor);
        if (descriptor != null) {
            this.controlImage.setDetailItem(descriptor.asItem());
            this.registrationManager.registerItem("value", descriptor.getItemId(), descriptor.getConnectionInformation(), false, false);
        }
    }

    @Override
    protected void updateState(Map<String, DataValue> values, SummaryInformation state) {
        if (this.isDisposed()) {
            logger.info("No updateView cause widget is disposed");
            return;
        }
        Variant value = null;
        if (this.getAttribute() == null) {
            try {
                value = values.get("value").getValue().getValue();
            }
            catch (NullPointerException e) {
                logger.info("could not get value", (Throwable)e);
                value = Variant.NULL;
            }
        } else {
            try {
                value = (Variant)values.get("value").getValue().getAttributes().get(this.getAttribute());
            }
            catch (NullPointerException e) {
                logger.info("could not get attribute", (Throwable)e);
                value = Variant.NULL;
            }
        }
        if (value == null) {
            this.text.setText("");
        } else if (value.isDouble()) {
            this.text.setText(this.getTextDecimal(values.get("value").getValue(), this.getAttribute(), this.factor));
            int progress = 0;
            try {
                progress = (int)(value.asDouble() * this.factor);
            }
            catch (NullValueException nullValueException) {
                logger.warn("progress could not be set");
            }
            catch (NotConvertableException notConvertableException) {
                logger.error("value is not convertable. Can't set progress");
            }
            this.progressBar.setSelection(progress);
        } else {
            this.text.setText("");
            this.progressBar.setSelection(0);
        }
    }
}

