/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantType;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.details.swt.data.DataItemDescriptor;
import org.eclipse.scada.vi.details.swt.dialog.WriteConfirmDialog;
import org.eclipse.scada.vi.details.swt.widgets.DescriptorLabel;
import org.eclipse.scada.vi.details.swt.widgets.Helper;
import org.eclipse.scada.vi.details.swt.widgets.WriteableComposite;
import org.eclipse.scada.vi.details.swt.widgets.control.BlockControlImage;
import org.eclipse.scada.vi.details.swt.widgets.control.ControlImage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextInputComposite
extends WriteableComposite {
    private static final Logger logger = LoggerFactory.getLogger(TextInputComposite.class);
    private final Text data;
    private final DataItemDescriptor descriptor;
    private final ControlImage controlImage;
    private final BlockControlImage blockImage;

    public TextInputComposite(Composite parent, int style, DataItemDescriptor descriptor, String format, Double ceil, double floor, String decimal, boolean isText, String attribute, DataItemDescriptor readDescriptor, String hdConnectionId, String hdItemId, int width, String queryString) {
        super(parent, style, format, decimal, isText, ceil, floor, attribute, hdConnectionId, hdItemId);
        this.descriptor = descriptor;
        if (width == 0) {
            width = 60;
        }
        GridLayout layout = new GridLayout(3, false);
        this.setLayout((Layout)layout);
        this.controlImage = new ControlImage(this, this.registrationManager);
        this.blockImage = new BlockControlImage(this.controlImage, 0, this.registrationManager);
        Helper.createTrendButton(this.controlImage, hdConnectionId, hdItemId, queryString);
        this.data = new Text((Composite)this, 133124);
        GridData data = new GridData(16384, 0x1000000, false, true);
        data.widthHint = data.minimumWidth = width;
        data.minimumHeight = -1;
        data.heightHint = -1;
        this.data.setLayoutData((Object)data);
        this.data.setEnabled(true);
        this.data.setText("");
        DescriptorLabel label = new DescriptorLabel(this, 0, format, descriptor);
        GridData labelData = new GridData(4, 0x1000000, true, false);
        labelData.minimumWidth = 100;
        label.setLayoutData(labelData);
        this.addDefaultKeyListener(this.data);
        if (descriptor != null) {
            if (readDescriptor != null) {
                this.registrationManager.registerItem("value", readDescriptor.getItemId(), readDescriptor.getConnectionInformation(), false, false);
                this.registrationManager.registerItem("valueWrite", descriptor.getItemId(), descriptor.getConnectionInformation(), false, false);
            } else {
                this.registrationManager.registerItem("value", descriptor.getItemId(), descriptor.getConnectionInformation(), false, false);
            }
            this.blockImage.setBlockItem(descriptor.asItem());
            this.controlImage.setDetailItem(descriptor.asItem());
        }
    }

    @Override
    protected void triggerCommand() {
        if (!WriteConfirmDialog.create(this.getShell())) {
            return;
        }
        try {
            this.data.setForeground(Display.getCurrent().getSystemColor(8));
            if (this.getAttribute() == null) {
                if (this.isText) {
                    this.registrationManager.startWrite(this.descriptor.getConnectionInformation(), this.descriptor.getItemId(), Variant.valueOf((Object)this.data.getText()), this.callbackHandler);
                } else {
                    this.registrationManager.startWrite(this.descriptor.getConnectionInformation(), this.descriptor.getItemId(), Variant.valueOf((Object)this.parseDecimal(this.data.getText())), this.callbackHandler);
                }
            } else {
                HashMap<String, Variant> attributes = new HashMap<String, Variant>();
                Variant variant = this.isText ? Variant.valueOf((Object)this.data.getText()) : Variant.valueOf((Object)this.parseDecimal(this.data.getText()));
                attributes.put(this.getAttribute(), variant);
                this.registrationManager.startWriteAttributes(this.descriptor.getConnectionInformation(), this.descriptor.getItemId(), attributes, this.callbackHandler);
            }
            this.getShell().setFocus();
        }
        catch (Exception exception) {}
    }

    @Override
    protected void updateState(Map<String, DataValue> values, SummaryInformation state) {
        if (this.isDisposed()) {
            logger.info("No updateView cause widget is disposed");
            return;
        }
        DataItemValue value = values.get("value").getValue();
        this.setCeil(value);
        this.setFloor(value);
        if (!this.data.isFocusControl()) {
            this.data.setText(this.getFormattedText(values, this.getAttribute()));
            this.data.setForeground(Display.getCurrent().getSystemColor(2));
            this.data.setBackground(Display.getCurrent().getSystemColor(1));
        } else {
            this.data.setBackground(Display.getCurrent().getSystemColor(7));
        }
        this.data.setEnabled(!state.isBlocked());
    }

    protected void writeSCADA(Variant value, Map<String, Variant> attributes, String type) {
        type.equals(VariantType.BOOLEAN.toString());
    }
}

