/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.utils.str.StringReplacer;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.details.model.URLImageComponent;
import org.eclipse.scada.vi.details.swt.Activator;
import org.eclipse.scada.vi.details.swt.Constants;
import org.eclipse.scada.vi.details.swt.data.DataItemDescriptor;
import org.eclipse.scada.vi.details.swt.widgets.GenericComposite;
import org.eclipse.scada.vi.details.swt.widgets.control.ControlImage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLImageLabel
extends GenericComposite {
    private static final Logger logger = LoggerFactory.getLogger(URLImageLabel.class);
    private final URLImageComponent component;
    private final Label label;
    private final LocalResourceManager resourceManager;
    private String currentUrl;
    private Image currentImage;
    private final ControlImage controlImage;

    public URLImageLabel(Composite parent, int style, DataItemDescriptor descriptor, URLImageComponent component) {
        super(parent, style, null, null);
        this.component = component;
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        layout.verticalSpacing = 3;
        layout.horizontalSpacing = 3;
        this.setLayout((Layout)layout);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.controlImage = new ControlImage(this, this.registrationManager);
        this.label = new Label((Composite)this, 0);
        GridData gd = new GridData(0x1000000, 0x1000000, true, true);
        if (component.getHeight() != null && component.getWidth() != null) {
            gd.minimumHeight = component.getHeight();
            gd.minimumWidth = component.getWidth();
            this.label.setSize(component.getWidth().intValue(), component.getHeight().intValue());
        }
        this.label.setLayoutData((Object)gd);
        if (descriptor != null) {
            this.controlImage.setDetailItem(descriptor.asItem());
            this.registrationManager.registerItem("value", descriptor.getItemId(), descriptor.getConnectionInformation(), false, false);
        }
        this.showUrl(component.getFallbackImageUrl());
    }

    @Override
    protected void handleDispose() {
        if (this.currentImage != null) {
            this.currentImage.dispose();
            this.currentImage = null;
        }
        this.resourceManager.dispose();
    }

    @Override
    protected void updateState(Map<String, DataValue> values, SummaryInformation aggregatedState) {
        if (this.isDisposed()) {
            logger.info("No updateView cause widget is disposed");
            return;
        }
        DataItemValue value = values.get("value").getValue();
        if (value == null || !value.isConnected() || value.getValue() == null || value.getValue().isNull()) {
            this.showUrl(this.component.getFallbackImageUrl());
        } else {
            try {
                this.showUrl(this.format(this.component.getImageUrl(), value.getValue().asString("")));
            }
            catch (Exception e) {
                logger.warn("Failed to load image", (Throwable)e);
                this.showUrl(this.component.getFallbackImageUrl());
            }
        }
    }

    private String format(String imageUrl, String string) throws UnsupportedEncodingException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("value", URLEncoder.encode(string, "UTF-8"));
        properties.put("properties", this.getProperties());
        String result = StringReplacer.replace((String)imageUrl, (StringReplacer.ReplaceSource)StringReplacer.newSource(properties), (Pattern)Constants.DEFAULT_PATTERN);
        logger.debug("Formatted URL - '{}' -> '{}'", (Object)imageUrl, (Object)result);
        return result;
    }

    private Map<String, String> getProperties() {
        if (org.eclipse.scada.core.ui.connection.login.Activator.getDefault().getSessionManager().getSession() == null) {
            return Collections.emptyMap();
        }
        if (org.eclipse.scada.core.ui.connection.login.Activator.getDefault().getSessionManager().getSession().getLoginContext() == null) {
            return Collections.emptyMap();
        }
        return org.eclipse.scada.core.ui.connection.login.Activator.getDefault().getSessionManager().getSession().getLoginContext().getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showUrl(final String url) {
        logger.debug("Requesting URL: {}", (Object)url);
        URLImageLabel uRLImageLabel = this;
        synchronized (uRLImageLabel) {
            if (this.currentUrl != null && this.currentUrl.equals(url)) {
                logger.debug("Image did not change");
                return;
            }
            this.currentUrl = url;
            Activator.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        URLImageLabel.this.processLoad(url);
                    }
                    catch (Exception e) {
                        logger.warn("Failed to load image", (Throwable)e);
                        try {
                            URLImageLabel.this.currentUrl = URLImageLabel.this.component.getFallbackImageUrl();
                            URLImageLabel.this.processLoad(URLImageLabel.this.component.getFallbackImageUrl());
                        }
                        catch (Exception e1) {
                            logger.warn("Failed to load fallback image", (Throwable)e1);
                        }
                    }
                }
            });
        }
    }

    private void processLoad(final String stringUrl) throws Exception {
        ImageLoader loader = new ImageLoader();
        URL url = new URL(stringUrl);
        final ImageData[] data = loader.load(url.openStream());
        logger.debug("Image loaded");
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                URLImageLabel.this.showImage(stringUrl, data);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showImage(String url, ImageData[] data) {
        if (this.isDisposed() || this.getDisplay().isDisposed()) {
            return;
        }
        if (data == null || data.length <= 0) {
            logger.info("No image data");
            return;
        }
        URLImageLabel uRLImageLabel = this;
        synchronized (uRLImageLabel) {
            if (url.equals(this.currentUrl)) {
                if (this.currentImage != null) {
                    this.currentImage.dispose();
                }
                this.currentImage = new Image((Device)this.getDisplay(), data[0]);
                this.label.setImage(this.currentImage);
            } else {
                logger.warn("Image url changed - current: {}, our: {}", (Object)this.currentUrl, (Object)url);
            }
        }
    }
}

