/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.editor.forms.common.marker;

import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.scada.ca.ui.editor.forms.common.ConfigurationFormToolkit;
import org.eclipse.scada.ca.ui.editor.forms.common.StandardConfigurationForm;
import org.eclipse.scada.ca.ui.editor.input.ConfigurationEditorInput;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class MarkerEditorForm
extends StandardConfigurationForm {
    @Override
    protected String getTitle(ConfigurationEditorInput input) {
        return String.format("Eclipse SCADA Marker Handler - %s: %s", input.getFactoryId(), input.getConfigurationId());
    }

    @Override
    protected void populateFormContent(ConfigurationFormToolkit toolkit, ScrolledForm form, ConfigurationEditorInput input) {
        Composite sectionClient = toolkit.createStandardSection(form.getBody(), "Marker Information");
        toolkit.createStandardCheckbox(sectionClient, "active", "Is the marker active", (IObservableMap)input.getDataMap(), String.class);
        toolkit.createStandardCheckbox(sectionClient, "exportAttribute", "Should the marker state be exported as DA attribute", (IObservableMap)input.getDataMap(), String.class);
        toolkit.createStandardCheckbox(sectionClient, "alwaysExport", "Should the marker be exported as DA attribute even when it is inactive", (IObservableMap)input.getDataMap(), String.class);
        sectionClient = toolkit.createStandardSection(form.getBody(), "Source Information");
        toolkit.createStandardLinkText(sectionClient, "master.item", "master.id", "Master Item Id", "ID of the master item", input, null);
        toolkit.createStandardText(sectionClient, "handlerPriority", "Handler Priority", "The sort order for the master handler list", (IObservableMap)input.getDataMap(), Integer.class);
        toolkit.createListSection(form, input, "master.id", "Master Items", ", ", ", ?");
        toolkit.createTableSection(form, input, "marker.", "Marker Values");
    }
}

