/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.connection.data;

import java.util.Date;
import java.util.Map;
import org.eclipse.scada.ae.connection.provider.ConnectionService;
import org.eclipse.scada.ae.data.MonitorStatus;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorStatusBean
extends AbstractPropertyChange {
    private static final Logger logger = LoggerFactory.getLogger(MonitorStatusBean.class);
    public static final String PROP_STATUS = "status";
    public static final String PROP_STATUS_TIMESTAMP = "statusTimestamp";
    public static final String PROP_VALUE = "value";
    public static final String PROP_LAST_AKN_USER = "lastAknUser";
    public static final String PROP_LAST_AKN_TIMESTAMP = "lastAknTimestamp";
    public static final String PROP_LAST_FAIL_TIMESTAMP = "lastFailTimestamp";
    public static final String PROP_ATTRIBUTES = "attributes";
    private final ConnectionService connection;
    private final String id;
    private MonitorStatus status;
    private Date statusTimestamp;
    private Variant value;
    private String lastAknUser;
    private Date lastAknTimestamp;
    private Date lastFailTimestamp;
    private Map<String, Variant> attributes;

    public MonitorStatusBean(ConnectionService connection, String id) {
        this.connection = connection;
        this.id = id;
    }

    public MonitorStatusBean(ConnectionService connection, MonitorStatusInformation information) {
        this(connection, information.getId());
        this.status = information.getStatus();
        this.statusTimestamp = new Date(information.getStatusTimestamp());
        this.value = information.getValue();
        this.lastAknUser = information.getLastAknUser();
        this.lastAknTimestamp = MonitorStatusBean.makeDate(information.getLastAknTimestamp());
        this.lastFailTimestamp = MonitorStatusBean.makeDate(information.getLastFailTimestamp());
        this.attributes = information.getAttributes();
    }

    private static Date makeDate(Long timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new Date(timestamp);
    }

    public String getId() {
        return this.id;
    }

    public ConnectionService getConnection() {
        return this.connection;
    }

    public MonitorStatus getStatus() {
        return this.status;
    }

    public void setStatus(MonitorStatus status) {
        this.status = status;
        this.firePropertyChange(PROP_STATUS, this.status, this.status);
    }

    public void update(MonitorStatusInformation info) {
        this.setStatus(info.getStatus());
        this.setStatusTimestamp(new Date(info.getStatusTimestamp()));
        this.setValue(info.getValue());
        this.setLastAknTimestamp(MonitorStatusBean.makeDate(info.getLastAknTimestamp()));
        this.setLastAknUser(info.getLastAknUser());
    }

    public Date getStatusTimestamp() {
        return this.statusTimestamp;
    }

    public void setStatusTimestamp(Date statusTimestamp) {
        this.statusTimestamp = statusTimestamp;
        this.firePropertyChange(PROP_STATUS_TIMESTAMP, this.statusTimestamp, this.statusTimestamp);
    }

    public Variant getValue() {
        return this.value;
    }

    public void setValue(Variant value) {
        this.value = value;
        this.firePropertyChange(PROP_VALUE, this.value, this.value);
    }

    public String getLastAknUser() {
        return this.lastAknUser;
    }

    public void setLastAknUser(String lastAknUser) {
        this.lastAknUser = lastAknUser;
        this.firePropertyChange(PROP_LAST_AKN_USER, this.lastAknUser, this.lastAknUser);
    }

    public Date getLastAknTimestamp() {
        return this.lastAknTimestamp;
    }

    public void setLastAknTimestamp(Date lastAknTimestamp) {
        this.lastAknTimestamp = lastAknTimestamp;
        this.firePropertyChange(PROP_LAST_AKN_TIMESTAMP, this.lastAknTimestamp, this.lastAknTimestamp);
    }

    public void akn() {
        logger.debug("Request ACK: {}", (Object)this.id);
        this.connection.getConnection().acknowledge(this.id, new Date(), null, null);
    }

    public Date getLastFailTimestamp() {
        return this.lastFailTimestamp;
    }

    public void setLastFailTimestamp(Date lastFailTimestamp) {
        this.lastFailTimestamp = lastFailTimestamp;
        this.firePropertyChange(PROP_LAST_FAIL_TIMESTAMP, this.lastFailTimestamp, this.lastFailTimestamp);
    }

    public Map<String, Variant> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Variant> attributes) {
        this.attributes = attributes;
        this.firePropertyChange(PROP_ATTRIBUTES, this.attributes, this.attributes);
    }
}

