/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.client.signalgenerator;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.ui.client.signalgenerator.Activator;
import org.eclipse.scada.da.ui.client.signalgenerator.GeneratorPageInformation;
import org.eclipse.scada.da.ui.client.signalgenerator.Messages;
import org.eclipse.scada.da.ui.client.signalgenerator.SimulationTarget;
import org.eclipse.scada.da.ui.client.signalgenerator.page.GeneratorPage;
import org.eclipse.scada.da.ui.connection.data.DataItemHolder;
import org.eclipse.scada.da.ui.connection.data.DataSourceListener;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class GeneratorView
extends ViewPart
implements SimulationTarget {
    public static final String VIEW_ID = "org.eclipse.scada.da.client.signalGenerator.GeneratorView";
    private CTabFolder tabFolder;
    private final List<GeneratorPageInformation> pages = new LinkedList<GeneratorPageInformation>();
    private GeneratorPageInformation activePage;
    private DataItemHolder item;
    private Composite header;
    private Button startButton;
    private Label errorLabel;

    public void createPartControl(Composite parent) {
        this.createPages();
        this.applyParentLayout(parent);
        this.createHeader(parent);
        this.createTabFolder(parent);
        this.updateState();
    }

    private void createTabFolder(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 1024);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        for (GeneratorPageInformation page : this.pages) {
            CTabItem tabItem = new CTabItem(this.tabFolder, 0);
            Composite tabComposite = new Composite((Composite)this.tabFolder, 0);
            tabComposite.setLayout((Layout)new FillLayout());
            page.getGeneratorPage().createPage(tabComposite);
            tabItem.setText(page.getLabel());
            tabItem.setControl((Control)tabComposite);
            page.getGeneratorPage().setTarget(this);
        }
        this.tabFolder.setSelection(0);
    }

    private void applyParentLayout(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
    }

    private void createHeader(Composite parent) {
        this.header = new Composite(parent, 0);
        this.header.setLayoutData((Object)new GridData(1, 1, true, false));
        this.header.setLayout((Layout)new RowLayout());
        this.startButton = new Button(this.header, 2);
        this.startButton.setText(Messages.getString("GeneratorView.ButtonGo"));
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneratorView.this.toggleButton(GeneratorView.this.startButton.getSelection());
            }
        });
        this.errorLabel = new Label(this.header, 0);
    }

    protected void toggleButton(boolean selection) {
        if (selection) {
            this.handleStart();
        } else {
            this.handleStop();
        }
    }

    protected GeneratorPageInformation getSelection() {
        try {
            return this.pages.get(this.tabFolder.getSelectionIndex());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void handleStop() {
        if (this.activePage != null) {
            this.activePage.getGeneratorPage().stop();
            this.activePage = null;
            this.updateState();
        }
    }

    private void handleStart() {
        this.handleStop();
        this.activePage = this.getSelection();
        if (this.activePage != null) {
            this.activePage.getGeneratorPage().start();
        }
        this.updateState();
    }

    private void updateState() {
        boolean state;
        boolean bl = state = this.activePage == null;
        if (this.startButton != null) {
            this.startButton.setEnabled(this.item != null);
            this.startButton.setSelection(!state);
            this.tabFolder.setEnabled(state);
        }
    }

    private void createPages() {
        try {
            for (GeneratorPageInformation info : this.getPageInformation()) {
                this.pages.add(info);
            }
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.getString("GeneratorView.createPages.error"), (String)Messages.getString("GeneratorView.createPages.errorMessage"), (IStatus)e.getStatus());
        }
    }

    public void dispose() {
        for (GeneratorPageInformation page : this.pages) {
            page.getGeneratorPage().dispose();
        }
        this.pages.clear();
        super.dispose();
    }

    public void setFocus() {
        this.tabFolder.setFocus();
    }

    public void setDataItem(Item item) {
        if (item != null) {
            this.item = new DataItemHolder(Activator.getDefault().getBundle().getBundleContext(), item, new DataSourceListener(){

                public void updateData(DataItemValue value) {
                    GeneratorView.this.updateData();
                }
            });
            this.setPartName(String.format(Messages.getString("GeneratorView.partName"), item.getId(), item.getConnectionString()));
        } else {
            this.setPartName(Messages.getString("GeneratorView.emptyPartName"));
        }
        this.updateState();
    }

    protected void updateData() {
    }

    private Collection<GeneratorPageInformation> getPageInformation() throws CoreException {
        LinkedList<GeneratorPageInformation> result = new LinkedList<GeneratorPageInformation>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.scada.da.client.signalGenerator");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("generatorPage".equals(element.getName())) {
                Object o = element.createExecutableExtension("class");
                if (!(o instanceof GeneratorPage)) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.scada.da.client.signalGenerator", Messages.getString("GeneratorView.classTypeMismatchError")));
                }
                GeneratorPageInformation info = new GeneratorPageInformation();
                info.setGeneratorPage((GeneratorPage)o);
                info.setLabel(element.getAttribute("label"));
                info.setSortKey(element.getAttribute("sortKey"));
                result.add(info);
            }
            ++n2;
        }
        Collections.sort(result, new Comparator<GeneratorPageInformation>(){

            @Override
            public int compare(GeneratorPageInformation arg0, GeneratorPageInformation arg1) {
                String key1 = arg0.getSortKey();
                String key2 = arg1.getSortKey();
                if (key1 == null) {
                    key1 = "";
                }
                if (key2 == null) {
                    key2 = "";
                }
                return key1.compareTo(key2);
            }
        });
        return result;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.setDataItem(Item.loadFrom((IMemento)memento));
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.item != null) {
            this.item.getItem().saveTo(memento);
        }
    }

    @Override
    public void writeValue(Variant value) {
        DataItemHolder item = this.item;
        if (item != null) {
            item.write(value);
        }
    }

    protected void setFailure(String reason) {
        if (reason != null) {
            this.triggerErrorLabel(reason);
        } else {
            this.triggerErrorLabel("");
        }
    }

    private void triggerErrorLabel(final String string) {
        Display d = this.errorLabel.getDisplay();
        if (!d.isDisposed()) {
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!GeneratorView.this.errorLabel.isDisposed()) {
                        GeneratorView.this.errorLabel.setText(string);
                    }
                }
            });
        }
    }
}

