/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.styles.generator;

import java.util.Set;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.scada.core.ui.styles.Activator;
import org.eclipse.scada.core.ui.styles.ColorUpdater;
import org.eclipse.scada.core.ui.styles.StateInformation;
import org.eclipse.scada.core.ui.styles.StyleHandler;
import org.eclipse.scada.core.ui.styles.generator.AbstractStyleGenerator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public abstract class SimpleRuleStyleGenerator
extends AbstractStyleGenerator {
    private static final ColorDescriptor COLOR_DISCONNECTED_BG = ColorDescriptor.createFrom((RGB)new RGB(233, 88, 254));
    private static final ColorDescriptor COLOR_ERROR_BG = ColorDescriptor.createFrom((RGB)new RGB(233, 88, 254));
    private static final ColorDescriptor COLOR_ALARM_BG = ColorDescriptor.createFrom((RGB)new RGB(235, 53, 37));
    private static final ColorDescriptor COLOR_WARNING_BG = ColorDescriptor.createFrom((RGB)new RGB(255, 222, 0));
    private static final ColorDescriptor COLOR_MANUAL_BG = ColorDescriptor.createFrom((RGB)new RGB(100, 149, 237));
    private static final ColorDescriptor COLOR_BLOCK_FG = ColorDescriptor.createFrom((RGB)new RGB(255, 255, 255));
    private static final ColorDescriptor COLOR_BLOCK_BG = ColorDescriptor.createFrom((RGB)new RGB(0, 0, 0));
    private final LocalResourceManager resourceManager;
    private final ColorUpdater colorBgDisconnected;
    private final ColorUpdater colorBgAlarm;
    private final ColorUpdater colorBgWarning;
    private final ColorUpdater colorBgManual;
    private final ColorUpdater colorBgBlock;
    private final ColorUpdater colorFgBlock;
    private final ColorUpdater colorBgError;
    private final IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            SimpleRuleStyleGenerator.this.fireConfigurationChanged();
        }
    };
    final Rule BLOCK_RULE = new Rule(){

        @Override
        public void test(Context context) {
            if (context.states.contains((Object)StateInformation.State.BLOCK)) {
                context.background = SimpleRuleStyleGenerator.this.colorBgBlock.getColor();
                context.foreground = SimpleRuleStyleGenerator.this.colorFgBlock.getColor();
                context.image = Activator.getDefault().getImageRegistry().get("block");
            }
        }
    };
    final Rule MANUAL_RULE = new Rule(){

        @Override
        public void test(Context context) {
            if (context.states.contains((Object)StateInformation.State.MANUAL)) {
                context.background = SimpleRuleStyleGenerator.this.colorBgManual.getColor();
                context.foreground = null;
                context.image = Activator.getDefault().getImageRegistry().get("manual");
            }
        }
    };
    final Rule WARNING_RULE = new Rule(){

        @Override
        public void test(Context context) {
            if (context.states.contains((Object)StateInformation.State.WARNING)) {
                context.warningActive = true;
                context.blink = false;
                context.background = SimpleRuleStyleGenerator.this.colorBgWarning.getColor();
                context.foreground = null;
                context.image = Activator.getDefault().getImageRegistry().get("warning");
            }
        }
    };
    final Rule WARNING_ACK_RULE = new Rule(){

        @Override
        public void test(Context context) {
            if (context.states.contains((Object)StateInformation.State.WARNING_ACK)) {
                context.background = SimpleRuleStyleGenerator.this.colorBgWarning.getColor();
                context.foreground = null;
                context.image = Activator.getDefault().getImageRegistry().get("warning");
                context.blink = true;
                context.fast = context.warningActive;
            }
        }
    };
    final Rule ALARM_RULE = new Rule(){

        @Override
        public void test(Context context) {
            if (context.states.contains((Object)StateInformation.State.ALARM)) {
                context.alarmActive = true;
                context.blink = false;
                context.background = SimpleRuleStyleGenerator.this.colorBgAlarm.getColor();
                context.foreground = null;
                context.image = Activator.getDefault().getImageRegistry().get("alarm");
            }
        }
    };
    final Rule ALARM_ACK_RULE = new Rule(){

        @Override
        public void test(Context context) {
            if (context.states.contains((Object)StateInformation.State.ALARM_ACK)) {
                context.background = SimpleRuleStyleGenerator.this.colorBgAlarm.getColor();
                context.foreground = null;
                context.image = Activator.getDefault().getImageRegistry().get("alarm");
                context.blink = true;
                context.fast = context.alarmActive;
            }
        }
    };
    final Rule ERROR_RULE = new Rule(){

        @Override
        public void test(Context context) {
            if (context.states.contains((Object)StateInformation.State.ERROR)) {
                context.errorActive = true;
                context.blink = false;
                context.background = SimpleRuleStyleGenerator.this.colorBgError.getColor();
                context.foreground = null;
                context.image = Activator.getDefault().getImageRegistry().get("error");
            }
        }
    };
    final Rule ERROR_ACK_RULE = new Rule(){

        @Override
        public void test(Context context) {
            if (context.states.contains((Object)StateInformation.State.ERROR_ACK)) {
                context.background = SimpleRuleStyleGenerator.this.colorBgError.getColor();
                context.foreground = null;
                context.image = Activator.getDefault().getImageRegistry().get("error");
                context.blink = true;
                context.fast = context.errorActive;
            }
        }
    };
    final Rule DISCONNECTED_RULE = new Rule(){

        @Override
        public void test(Context context) {
            if (context.states.contains((Object)StateInformation.State.DISCONNECTED)) {
                context.background = SimpleRuleStyleGenerator.this.colorBgDisconnected.getColor();
                context.foreground = null;
                context.image = Activator.getDefault().getImageRegistry().get("disconnected");
            }
        }
    };

    public SimpleRuleStyleGenerator() {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.colorBgDisconnected = new ColorUpdater("org.eclipse.scada.core.ui.styles.alarming.disconnected.bg", (ResourceManager)this.resourceManager, COLOR_DISCONNECTED_BG);
        this.colorBgError = new ColorUpdater("org.eclipse.scada.core.ui.styles.alarming.error.bg", (ResourceManager)this.resourceManager, COLOR_ERROR_BG);
        this.colorBgAlarm = new ColorUpdater("org.eclipse.scada.core.ui.styles.alarming.alarm.bg", (ResourceManager)this.resourceManager, COLOR_ALARM_BG);
        this.colorBgWarning = new ColorUpdater("org.eclipse.scada.core.ui.styles.alarming.warning.bg", (ResourceManager)this.resourceManager, COLOR_WARNING_BG);
        this.colorBgManual = new ColorUpdater("org.eclipse.scada.core.ui.styles.alarming.manual.bg", (ResourceManager)this.resourceManager, COLOR_MANUAL_BG);
        this.colorBgBlock = new ColorUpdater("org.eclipse.scada.core.ui.styles.alarming.block.bg", (ResourceManager)this.resourceManager, COLOR_BLOCK_BG);
        this.colorFgBlock = new ColorUpdater("org.eclipse.scada.core.ui.styles.alarming.block.fg", (ResourceManager)this.resourceManager, COLOR_BLOCK_FG);
        JFaceResources.getColorRegistry().addListener(this.listener);
    }

    protected abstract Rule[] getRules();

    @Override
    public StyleHandler.Style generateStyle(StateInformation state) {
        if (state == null) {
            return null;
        }
        Context context = new Context();
        context.states = state.getStates();
        Rule[] ruleArray = this.getRules();
        int n = ruleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rule rule = ruleArray[n2];
            rule.test(context);
            ++n2;
        }
        if (context.blink) {
            if (context.fast) {
                Image[] imageArray = new Image[2];
                imageArray[0] = context.image;
                Color[] colorArray = new Color[2];
                colorArray[0] = context.foreground;
                Color[] colorArray2 = new Color[2];
                colorArray2[0] = context.background;
                return new StyleHandler.Style(imageArray, colorArray, colorArray2, null);
            }
            Image[] imageArray = new Image[6];
            imageArray[0] = context.image;
            imageArray[1] = context.image;
            imageArray[2] = context.image;
            Color[] colorArray = new Color[6];
            colorArray[0] = context.foreground;
            colorArray[1] = context.foreground;
            colorArray[2] = context.foreground;
            Color[] colorArray3 = new Color[6];
            colorArray3[0] = context.background;
            colorArray3[1] = context.background;
            colorArray3[2] = context.background;
            return new StyleHandler.Style(imageArray, colorArray, colorArray3, null);
        }
        return new StyleHandler.Style(new Image[]{context.image}, new Color[]{context.foreground}, new Color[]{context.background}, null);
    }

    @Override
    public void dispose() {
        JFaceResources.getColorRegistry().removeListener(this.listener);
        this.resourceManager.dispose();
    }

    private static class Context {
        Set<StateInformation.State> states;
        Image image;
        Color background;
        Color foreground;
        boolean blink = false;
        boolean fast = true;
        boolean warningActive = false;
        boolean alarmActive = false;
        boolean errorActive = false;

        private Context() {
        }
    }

    public static interface Rule {
        public void test(Context var1);
    }
}

