/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.contributions;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.ae.data.MonitorStatus;
import org.eclipse.scada.ae.ui.views.Activator;
import org.eclipse.scada.ae.ui.views.config.AlarmNotifierConfiguration;
import org.eclipse.scada.ae.ui.views.config.ConfigurationHelper;
import org.eclipse.scada.ae.ui.views.contributions.Messages;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.connection.provider.ConnectionIdTracker;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.connection.provider.ConnectionTracker;
import org.eclipse.scada.core.ui.styles.StateInformation;
import org.eclipse.scada.core.ui.styles.StateStyler;
import org.eclipse.scada.core.ui.styles.StaticStateInformation;
import org.eclipse.scada.core.ui.styles.StyleBlinker;
import org.eclipse.scada.core.ui.styles.StyleHandler;
import org.eclipse.scada.da.client.DataItem;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmNotifier
extends WorkbenchWindowControlContribution {
    private static final List<String> ALARM_STATES = Arrays.asList("NOT_OK", "NOT_OK_AKN", "NOT_OK_NOT_AKN");
    private static final List<String> ACK_STATES = Arrays.asList("NOT_AKN", "NOT_OK_NOT_AKN");
    private static final Logger logger = LoggerFactory.getLogger(AlarmNotifier.class);
    public static final String ID = "org.eclipse.scada.ae.ui.views.contributions.alarmnotifier";
    private ResourceManager resourceManager;
    private Label label;
    private ParameterizedCommand ackAlarmsAvailableCommand;
    private ParameterizedCommand alarmsAvailableCommand;
    private String connectionId;
    protected org.eclipse.scada.da.connection.provider.ConnectionService connectionService;
    private ConnectionIdTracker connectionTracker;
    private String prefix;
    private final Map<String, AtomicInteger> monitorStatus = new HashMap<String, AtomicInteger>();
    private Composite panel;
    private Clip clip;
    private URL soundFile;
    private volatile boolean connected = false;
    private final Collection<DataItem> items = new HashSet<DataItem>();
    private Display display;
    private Label bellIcon;
    private StyleBlinker blinker;
    private StateStyler styler;

    public AlarmNotifier() {
    }

    public AlarmNotifier(String id) {
        super(id);
    }

    public void dispose() {
        this.onDisconnect();
        if (this.blinker != null) {
            this.blinker.dispose();
        }
        if (this.styler != null) {
            this.styler.dispose();
        }
        this.resourceManager.dispose();
        super.dispose();
    }

    protected Control createControl(Composite parent) {
        this.display = parent.getDisplay();
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.initMonitorStates();
        this.panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.panel.setLayout((Layout)layout);
        this.panel.setCursor(this.display.getSystemCursor(21));
        this.label = new Label(this.panel, 0);
        this.label.setText(this.getLabel());
        this.label.setAlignment(0x1000000);
        GridData gd = new GridData(0x1000000, 0x1000000, true, true);
        gd.minimumWidth = 110;
        gd.widthHint = 110;
        this.label.setLayoutData((Object)gd);
        this.label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                AlarmNotifier.this.triggerMainCommand();
            }
        });
        this.bellIcon = new Label(this.panel, 0);
        this.bellIcon.setAlignment(0x1000000);
        gd = new GridData(4, 4, false, true);
        gd.widthHint = gd.minimumWidth = this.getBellIcon().getBounds().width;
        this.bellIcon.setLayoutData((Object)gd);
        this.bellIcon.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                AlarmNotifier.this.triggerBellSwitch();
            }
        });
        this.blinker = new StyleBlinker(){

            public void update(StyleBlinker.CurrentStyle style) {
                AlarmNotifier.this.handleStyleUpdate(style);
            }
        };
        this.blinker.setStyle(null);
        this.styler = new StateStyler((StyleHandler)this.blinker);
        this.loadConfiguration();
        return this.panel;
    }

    protected void handleStyleUpdate(StyleBlinker.CurrentStyle style) {
        this.setBackground(style.background);
    }

    private void initMonitorStates() {
        MonitorStatus[] monitorStatusArray = MonitorStatus.values();
        int n = monitorStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            MonitorStatus ms = monitorStatusArray[n2];
            this.monitorStatus.put(ms.name(), new AtomicInteger(0));
            ++n2;
        }
    }

    protected void setBackground(Color color) {
        if (this.panel.isDisposed()) {
            return;
        }
        this.panel.setBackground(color);
        this.label.setBackground(color);
        this.bellIcon.setBackground(color);
    }

    protected void triggerBellSwitch() {
        try {
            this.connectionService.getConnection().write(this.getItemId("ALERT_ACTIVE"), Variant.FALSE, null, null);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.scada.ae.ui.views", Messages.AlarmNotifier_Status_ErrorWriteBellCommand, (Throwable)e));
        }
    }

    private void loadConfiguration() {
        AlarmNotifierConfiguration cfg = ConfigurationHelper.findAlarmNotifierConfiguration();
        if (cfg != null) {
            try {
                this.setConfiguration(cfg);
            }
            catch (Exception e) {
                logger.warn("Failed to apply configuration", (Throwable)e);
            }
        } else {
            logger.info("no configuration found");
        }
    }

    private void setConfiguration(AlarmNotifierConfiguration cfg) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.connectionId = cfg.getConnectionId();
        this.prefix = cfg.getPrefix();
        this.soundFile = cfg.getSoundFile();
        this.ackAlarmsAvailableCommand = cfg.getAckAlarmsAvailableCommand();
        this.alarmsAvailableCommand = cfg.getAlarmsAvailableCommand();
        this.initConnection();
    }

    private void initConnection() {
        if (this.connectionId == null) {
            return;
        }
        ConnectionTracker.Listener connectionServiceListener = new ConnectionTracker.Listener(){

            public void setConnection(ConnectionService connectionService) {
                AlarmNotifier.this.setConnectionService(connectionService);
            }
        };
        this.connectionTracker = new ConnectionIdTracker(Activator.getDefault().getBundle().getBundleContext(), this.connectionId, connectionServiceListener);
        this.connectionService = null;
        this.connectionTracker.open();
    }

    private void onDisconnect() {
        for (DataItem item : this.items) {
            item.deleteObservers();
            item.unregister();
        }
        this.items.clear();
        this.initMonitorStates();
        this.connected = false;
        this.disableHorn();
        this.updateAlarms();
    }

    private String getItemId(String localId) {
        return String.valueOf(this.prefix) + "." + localId;
    }

    private void onConnect() {
        MonitorStatus[] monitorStatusArray = MonitorStatus.values();
        int n = monitorStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            final MonitorStatus ms = monitorStatusArray[n2];
            String id = this.getItemId(ms.name());
            DataItem item = new DataItem(id);
            item.addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    AlarmNotifier.this.updateMonitorStatus(ms, (DataItemValue)arg);
                }
            });
            item.register(this.connectionService.getItemManager());
            this.items.add(item);
            ++n2;
        }
        String id = this.getItemId("ALERT_ACTIVE");
        DataItem item = new DataItem(id);
        item.addObserver(new Observer(){

            @Override
            public void update(Observable o, final Object arg) {
                AlarmNotifier.this.trigger(new Runnable(){

                    @Override
                    public void run() {
                        AlarmNotifier.this.updateActiveState((DataItemValue)arg);
                    }
                });
            }
        });
        item.register(this.connectionService.getItemManager());
        this.items.add(item);
    }

    private void triggerMainCommand() {
        try {
            if (this.numberOfAckAlarms() > 0) {
                this.executeCommand(this.ackAlarmsAvailableCommand);
            } else {
                this.executeCommand(this.alarmsAvailableCommand);
            }
        }
        catch (PartInitException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void executeCommand(ParameterizedCommand command) throws PartInitException {
        IHandlerService handlerService = (IHandlerService)this.getWorkbenchWindow().getService(IHandlerService.class);
        if (command.getCommand().isDefined()) {
            try {
                handlerService.executeCommand(command, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void trigger(final Runnable run) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AlarmNotifier.this.display.isDisposed()) {
                    return;
                }
                run.run();
            }
        });
    }

    private void updateAlarms() {
        this.trigger(new Runnable(){

            @Override
            public void run() {
                if (!AlarmNotifier.this.panel.isDisposed() && !AlarmNotifier.this.label.isDisposed()) {
                    AlarmNotifier.this.updateState();
                    AlarmNotifier.this.label.setText(AlarmNotifier.this.getLabel());
                }
            }
        });
    }

    protected void updateState() {
        EnumSet<StateInformation.State> states = EnumSet.noneOf(StateInformation.State.class);
        if (this.numberOfAlarms() > 0) {
            states.add(StateInformation.State.ALARM);
        }
        if (this.numberOfAckAlarms() > 0) {
            states.add(StateInformation.State.ALARM_ACK);
        }
        if (!this.connected) {
            states.add(StateInformation.State.DISCONNECTED);
        }
        this.styler.style((StateInformation)new StaticStateInformation(states));
    }

    private void disableHorn() {
        if (this.clip != null) {
            this.clip.stop();
            this.clip.close();
            this.clip = null;
        }
        if (!this.bellIcon.isDisposed()) {
            this.bellIcon.setImage(null);
        }
    }

    private void enableHorn() throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        if ((this.clip == null || !this.clip.isRunning()) && Activator.getDefault().getPreferenceStore().getBoolean("bellActivated")) {
            AudioInputStream sound = AudioSystem.getAudioInputStream(this.soundFile);
            DataLine.Info info = new DataLine.Info(Clip.class, sound.getFormat());
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.open(sound);
            this.clip.loop(-1);
        }
        if (!this.bellIcon.isDisposed()) {
            this.bellIcon.setImage(this.getBellIcon());
        }
    }

    private Image getBellIcon() {
        return this.resourceManager.createImageWithDefault(ImageDescriptor.createFromFile(AlarmNotifier.class, (String)"icons/bell.png"));
    }

    private int numberOfAckAlarms() {
        int alarms = 0;
        for (Map.Entry<String, AtomicInteger> entry : this.monitorStatus.entrySet()) {
            if (!ACK_STATES.contains(entry.getKey())) continue;
            alarms += entry.getValue().get();
        }
        return alarms;
    }

    private int numberOfAlarms() {
        int alarms = 0;
        for (Map.Entry<String, AtomicInteger> entry : this.monitorStatus.entrySet()) {
            if (!ALARM_STATES.contains(entry.getKey())) continue;
            alarms += entry.getValue().get();
        }
        return alarms;
    }

    private String getLabel() {
        if (this.connectionService == null || this.connectionService.getConnection().getState() != ConnectionState.BOUND) {
            return Messages.AlarmNotifier_Label_State_Disconnected;
        }
        if (this.numberOfAlarms() + this.numberOfAckAlarms() == 0) {
            return Messages.AlarmNotifier_Label_State_NoAlarm;
        }
        return String.format(Messages.AlarmNotifier_Label_State_AlarmsFormat, this.numberOfAckAlarms(), this.numberOfAlarms());
    }

    private void setConnectionService(ConnectionService connectionService) {
        if (connectionService == null) {
            this.onDisconnect();
            this.connectionService = null;
            return;
        }
        this.connectionService = (org.eclipse.scada.da.connection.provider.ConnectionService)connectionService;
        this.onConnect();
    }

    protected void updateMonitorStatus(MonitorStatus ms, DataItemValue value) {
        this.monitorStatus.get(ms.name()).set(value.getValue().asInteger(Integer.valueOf(0)));
        this.updateAlarms();
    }

    protected void updateActiveState(DataItemValue value) {
        this.connected = value.isConnected();
        this.updateState();
        if (value.getValue().asBoolean(Boolean.valueOf(false)).booleanValue()) {
            try {
                this.enableHorn();
            }
            catch (Exception e) {
                logger.error("could not play sound!", (Throwable)e);
            }
        } else {
            this.disableHorn();
        }
    }
}

