/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.dialog;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.scada.ae.ui.views.Messages;
import org.eclipse.scada.ae.ui.views.dialog.FilterChangedListener;
import org.eclipse.scada.ae.ui.views.dialog.SearchType;
import org.eclipse.scada.ae.ui.views.filter.FilterTab;
import org.eclipse.scada.ae.ui.views.filter.FreeFormTab;
import org.eclipse.scada.ae.ui.views.filter.QueryByExampleTab;
import org.eclipse.scada.utils.lang.Pair;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.statushandlers.StatusManager;

public class EventHistorySearchDialog
extends TitleAreaDialog
implements FilterChangedListener {
    private static final String EXTP_FILTER_TAB = "org.eclipse.scada.ae.ui.views.filterTab";
    private final Pair<SearchType, String> initialFilter;
    private Pair<SearchType, String> filter;

    private EventHistorySearchDialog(Shell parentShell, Pair<SearchType, String> filter) {
        super(parentShell);
        this.initialFilter = filter;
        this.filter = null;
    }

    protected List<FilterTab> getFilterTabs() {
        LinkedList<FilterTab> result = new LinkedList<FilterTab>();
        result.add(new QueryByExampleTab());
        result.add(new FreeFormTab());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_FILTER_TAB);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            if ("filterTab".equals(ele.getName())) {
                try {
                    result.add((FilterTab)ele.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e.getStatus());
                }
            }
            ++n2;
        }
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.search_for_events);
        this.setMessage(Messages.search_for_events_description);
        Composite rootComposite = (Composite)super.createDialogArea(parent);
        String filterString = "";
        if (this.initialFilter != null && this.initialFilter.second != null) {
            filterString = (String)this.initialFilter.second;
        }
        TabFolder tabFolder = new TabFolder(rootComposite, 0);
        for (FilterTab tab : this.getFilterTabs()) {
            TabItem tabItem = new TabItem(tabFolder, 0);
            tabItem.setText(tab.getName());
            tabItem.setControl(tab.createControl((Composite)tabFolder, this, 0, filterString));
        }
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 4;
        layoutData.grabExcessVerticalSpace = true;
        tabFolder.setLayoutData((Object)layoutData);
        this.selectInitialFilterPage(tabFolder);
        return rootComposite;
    }

    private void selectInitialFilterPage(TabFolder tabFolder) {
        if (this.initialFilter == null) {
            return;
        }
        switch ((SearchType)((Object)this.initialFilter.first)) {
            case SIMPLE: {
                tabFolder.setSelection(0);
                break;
            }
            case FREEFORM: {
                tabFolder.setSelection(1);
                break;
            }
        }
    }

    public boolean close() {
        if (this.getReturnCode() != 0) {
            this.filter = null;
        }
        return super.close();
    }

    public Pair<SearchType, String> getFilter() {
        return this.filter;
    }

    public static Pair<SearchType, String> open(Shell parentShell, Pair<SearchType, String> filter) {
        EventHistorySearchDialog dialog = new EventHistorySearchDialog(parentShell, filter);
        dialog.open();
        return dialog.getFilter();
    }

    @Override
    public void onFilterChanged(Pair<SearchType, String> filter) {
        this.filter = filter;
    }

    @Override
    public void onFilterParseError(Pair<SearchType, String> error) {
        this.setErrorMessage((String)error.second);
    }
}

