/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.dialog;

import org.eclipse.scada.ae.ui.views.Messages;
import org.eclipse.scada.ae.ui.views.dialog.FilterChangedListener;
import org.eclipse.scada.ae.ui.views.dialog.SearchType;
import org.eclipse.scada.utils.filter.Filter;
import org.eclipse.scada.utils.filter.FilterParseException;
import org.eclipse.scada.utils.filter.FilterParser;
import org.eclipse.scada.utils.lang.Pair;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterFreeFormComposite
extends Composite {
    private static final Logger logger = LoggerFactory.getLogger(FilterFreeFormComposite.class);
    private final FilterChangedListener filterChangedListener;
    private final String filter;

    public FilterFreeFormComposite(FilterChangedListener filterChangedListener, Composite parent, int style, String filter) {
        super(parent, style);
        if (filter == null) {
            throw new IllegalArgumentException(Messages.filter_must_not_be_null);
        }
        this.filterChangedListener = filterChangedListener;
        this.filter = filter;
        this.createComponents();
    }

    private void createComponents() {
        FillLayout layout = new FillLayout(512);
        layout.marginHeight = 12;
        layout.marginWidth = 12;
        this.setLayout((Layout)layout);
        final Text filterTextField = new Text((Composite)this, 2882);
        filterTextField.setText(this.filter);
        filterTextField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                FilterFreeFormComposite.this.verifyFilter(filterTextField.getText());
            }
        });
    }

    public boolean verifyFilter(String filter) {
        try {
            Filter parsedFilter = new FilterParser(filter).getFilter();
            this.filterChangedListener.onFilterChanged((Pair<SearchType, String>)new Pair((Object)SearchType.FREEFORM, (Object)parsedFilter.toString()));
        }
        catch (FilterParseException e) {
            this.filterChangedListener.onFilterParseError((Pair<SearchType, String>)new Pair((Object)SearchType.FREEFORM, (Object)e.getMessage()));
            return false;
        }
        catch (Exception e) {
            logger.info("Failed to parse", (Throwable)e);
        }
        this.filterChangedListener.onFilterParseError((Pair<SearchType, String>)new Pair((Object)SearchType.FREEFORM, null));
        return true;
    }
}

