/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.connection.dnd;

import java.util.Collection;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.connection.data.ItemSelectionHelper;
import org.eclipse.scada.da.ui.connection.dnd.ItemTransfer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemDragSourceListener
implements DragSourceListener {
    private static final Logger logger = LoggerFactory.getLogger(ItemDragSourceListener.class);
    private final Viewer viewer;

    public ItemDragSourceListener(Viewer viewer) {
        this.viewer = viewer;
    }

    public void dragFinished(DragSourceEvent event) {
    }

    public void dragSetData(DragSourceEvent event) {
        try {
            if (ItemTransfer.getInstance().isSupportedType(event.dataType)) {
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                Collection<Item> items = ItemSelectionHelper.getSelection((ISelection)selection);
                event.data = items.toArray(new Item[items.size()]);
                event.doit = true;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to set drag data", (Throwable)e);
            event.doit = false;
        }
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = false;
        if (!(this.viewer.getSelection() instanceof IStructuredSelection)) {
            return;
        }
        Collection<Item> items = ItemSelectionHelper.getSelection(this.viewer.getSelection());
        if (!items.isEmpty()) {
            LocalSelectionTransfer.getTransfer().setSelection(this.viewer.getSelection());
            event.doit = true;
        }
    }
}

