/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.ui.providers.internal;

import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scada.sec.ui.providers.Key;
import org.eclipse.scada.sec.ui.providers.KeyProvider;
import org.eclipse.scada.sec.ui.providers.KeyProviderFactory;
import org.eclipse.scada.ui.databinding.ListeningStyledCellLabelProvider;
import org.eclipse.swt.graphics.Image;

public final class LabelProviderImpl
extends ListeningStyledCellLabelProvider {
    private final ResourceManager manager;
    private final Image locked;

    public LabelProviderImpl(ResourceManager manager, IObservableSet itemsThatNeedLabels) {
        super(itemsThatNeedLabels);
        this.manager = manager;
        this.locked = this.manager.createImageWithDefault(ImageDescriptor.createFromFile(LabelProviderImpl.class, (String)"icons/blocked.gif"));
    }

    public void update(ViewerCell cell) {
        Object ele = cell.getElement();
        if (ele instanceof KeyProviderFactory) {
            cell.setText(ele.toString());
        } else if (ele instanceof KeyProvider) {
            KeyProvider keyProvider = (KeyProvider)ele;
            cell.setText(keyProvider.toString());
            cell.setImage(keyProvider.isLocked() ? this.locked : null);
        } else if (ele instanceof Key) {
            Key key = (Key)ele;
            cell.setText(key.toString());
            cell.setImage(key.isLocked() ? this.locked : null);
        }
    }

    protected void addListenerTo(Object next) {
        if (next instanceof KeyProvider) {
            this.listenTo(next, (IValueProperty)BeanProperties.value(KeyProvider.class, (String)"locked"));
        } else if (next instanceof Key) {
            this.listenTo(next, (IValueProperty)BeanProperties.value(Key.class, (String)"locked"));
        }
    }

    protected void removeListenerFrom(Object element) {
    }
}

