/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.draw2d;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.ui.databinding.AdapterHelper;
import org.eclipse.scada.vi.model.Arc;
import org.eclipse.scada.vi.model.BorderContainer;
import org.eclipse.scada.vi.model.Connection;
import org.eclipse.scada.vi.model.Dimension;
import org.eclipse.scada.vi.model.Ellipse;
import org.eclipse.scada.vi.model.FigureContainer;
import org.eclipse.scada.vi.model.GridContainer;
import org.eclipse.scada.vi.model.Image;
import org.eclipse.scada.vi.model.Line;
import org.eclipse.scada.vi.model.Position;
import org.eclipse.scada.vi.model.Primitive;
import org.eclipse.scada.vi.model.StackContainer;
import org.eclipse.scada.vi.model.SymbolReference;
import org.eclipse.scada.vi.model.Text;
import org.eclipse.scada.vi.model.XYContainer;
import org.eclipse.scada.vi.ui.draw2d.Activator;
import org.eclipse.scada.vi.ui.draw2d.Controller;
import org.eclipse.scada.vi.ui.draw2d.SymbolController;
import org.eclipse.scada.vi.ui.draw2d.ViewElementFactory;
import org.eclipse.scada.vi.ui.draw2d.loader.SymbolLoader;
import org.eclipse.scada.vi.ui.draw2d.loader.XMISymbolLoader;
import org.eclipse.scada.vi.ui.draw2d.primitives.ArcController;
import org.eclipse.scada.vi.ui.draw2d.primitives.BorderContainerController;
import org.eclipse.scada.vi.ui.draw2d.primitives.EllipseController;
import org.eclipse.scada.vi.ui.draw2d.primitives.FigureContainerController;
import org.eclipse.scada.vi.ui.draw2d.primitives.GridContainerController;
import org.eclipse.scada.vi.ui.draw2d.primitives.ImageController;
import org.eclipse.scada.vi.ui.draw2d.primitives.LineController;
import org.eclipse.scada.vi.ui.draw2d.primitives.RectangleController;
import org.eclipse.scada.vi.ui.draw2d.primitives.StackContainerController;
import org.eclipse.scada.vi.ui.draw2d.primitives.SymbolReferenceController;
import org.eclipse.scada.vi.ui.draw2d.primitives.TextController;
import org.eclipse.scada.vi.ui.draw2d.primitives.XYContainerController;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicViewElementFactory {
    private static final Logger logger = LoggerFactory.getLogger(BasicViewElementFactory.class);
    private final ResourceManager manager;
    private final Map<URI, XMISymbolLoader> symbolCache = new HashMap<URI, XMISymbolLoader>();
    private final FigureCanvas canvas;
    private final SymbolLoader symbolLoader;

    public BasicViewElementFactory(FigureCanvas canvas, ResourceManager manager, SymbolLoader symbolLoader) {
        this.manager = manager;
        this.canvas = canvas;
        this.symbolLoader = symbolLoader;
    }

    public Controller create(SymbolController controller, Primitive element) throws Exception {
        if (element == null) {
            StatusManager.getManager().handle((IStatus)new Status(1, "org.eclipse.scada.vi.ui.draw2d", "Empty element found"), 1);
            return new Controller(){

                @Override
                public IFigure getFigure() {
                    return new Label("");
                }
            };
        }
        if (element instanceof XYContainer) {
            return new XYContainerController(controller, (XYContainer)element, this);
        }
        if (element instanceof Text) {
            return new TextController(this.canvas, controller, (Text)element, this.manager);
        }
        if (element instanceof Line) {
            return new LineController(controller, (Line)element, this.manager);
        }
        if (element instanceof Arc) {
            return new ArcController(controller, (Arc)element, this.manager);
        }
        if (element instanceof SymbolReference) {
            XMISymbolLoader subLoader = this.load(((SymbolReference)element).getUri());
            return new SymbolReferenceController(controller, (SymbolReference)element, this.createSubFactory(subLoader), this.manager);
        }
        if (element instanceof org.eclipse.scada.vi.model.Rectangle) {
            return new RectangleController(controller, (org.eclipse.scada.vi.model.Rectangle)element, this.manager);
        }
        if (element instanceof Ellipse) {
            return new EllipseController(controller, (Ellipse)element, this.manager);
        }
        if (element instanceof GridContainer) {
            return new GridContainerController(controller, (GridContainer)element, this);
        }
        if (element instanceof BorderContainer) {
            return new BorderContainerController(controller, (BorderContainer)element, this);
        }
        if (element instanceof FigureContainer) {
            return new FigureContainerController(controller, (FigureContainer)element, this.manager, this);
        }
        if (element instanceof StackContainer) {
            return new StackContainerController(controller, (StackContainer)element, this);
        }
        if (element instanceof Image) {
            return new ImageController(this.canvas, controller, (Image)element, this.symbolLoader, this.manager);
        }
        ViewElementFactory factory = Activator.createFactory((EObject)element);
        if (factory != null) {
            return factory.create(controller, element, this.symbolLoader, this.manager, this);
        }
        throw new IllegalArgumentException(String.format("Element type %s is unknown", element.eClass().getName()));
    }

    public Rectangle create(Position position, Dimension dimension) {
        PrecisionRectangle rect = new PrecisionRectangle();
        if (position != null) {
            rect.setPreciseLocation(position.getX(), position.getY());
        } else {
            rect.setPreciseLocation(0.0, 0.0);
        }
        if (dimension == null) {
            rect.setPreciseSize(-1.0, -1.0);
        } else {
            rect.setPreciseSize(dimension.getWidth(), dimension.getHeight());
        }
        return rect;
    }

    protected XMISymbolLoader load(String stringUri) throws Exception {
        URI uri = URI.createURI((String)this.symbolLoader.resolveUri(stringUri));
        XMISymbolLoader symbol = this.symbolCache.get(uri);
        if (symbol != null) {
            return symbol;
        }
        logger.info("Loading: {}", (Object)uri);
        XMISymbolLoader loader = new XMISymbolLoader(uri);
        this.symbolCache.put(uri, loader);
        return loader;
    }

    public SymbolLoader getRoot() {
        return this.symbolLoader;
    }

    public BasicViewElementFactory createSubFactory(SymbolLoader symbolLoader) {
        return new BasicViewElementFactory(this.canvas, this.manager, symbolLoader);
    }

    public void createConnections(Layer layer, SymbolController controller, EList<Connection> connections) {
        if (connections == null) {
            return;
        }
        for (Connection connection : connections) {
            Controller start = (Controller)AdapterHelper.adapt((Object)controller.getElement(connection.getStart()), Controller.class);
            Controller end = (Controller)AdapterHelper.adapt((Object)controller.getElement(connection.getEnd()), Controller.class);
            if (start == null || end == null) continue;
            PolylineConnection c = new PolylineConnection();
            c.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor(start.getFigure()));
            c.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor(end.getFigure()));
            c.setAntialias(1);
            layer.add((IFigure)c);
        }
    }
}

