/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scada.ca.ui.data.ConfigurationEditorSourceInformation;
import org.eclipse.scada.ca.ui.data.FactoryEditorSourceInformation;
import org.eclipse.scada.ca.ui.editor.input.ConfigurationEditorInput;
import org.eclipse.scada.ca.ui.editor.input.FactoryEditorInput;
import org.eclipse.scada.ui.databinding.AdapterHelper;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.statushandlers.StatusManager;

public class EditorHelper {
    public static IEditorInput[] createInput(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Iterator i = ((IStructuredSelection)selection).iterator();
            ArrayList<Object> result = new ArrayList<Object>();
            while (i.hasNext()) {
                ConfigurationEditorSourceInformation config;
                Object o = i.next();
                FactoryEditorSourceInformation factory = (FactoryEditorSourceInformation)AdapterHelper.adapt(o, FactoryEditorSourceInformation.class);
                if (factory != null) {
                    FactoryEditorInput input = new FactoryEditorInput(factory.getConnection(), factory.getFactoryId());
                    result.add(input);
                }
                if ((config = (ConfigurationEditorSourceInformation)AdapterHelper.adapt(o, ConfigurationEditorSourceInformation.class)) == null) continue;
                ConfigurationEditorInput input = new ConfigurationEditorInput(config.getConnectionId(), config.getFactoryId(), config.getConfigurationId());
                result.add(input);
            }
            return result.toArray(new IEditorInput[0]);
        }
        return new IEditorInput[0];
    }

    public static void handleOpen(IWorkbenchPage page, ISelection selection) {
        IEditorInput[] inputs;
        MultiStatus status = new MultiStatus("org.eclipse.scada.ca.ui.editor", 0, "Open editor", null);
        IEditorInput[] iEditorInputArray = inputs = EditorHelper.createInput(selection);
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorInput input = iEditorInputArray[n2];
            try {
                if (input instanceof ConfigurationEditorInput) {
                    page.openEditor(input, "org.eclipse.scada.ca.ui.connection.editors.MultiConfigurationEditor", true);
                } else if (input instanceof FactoryEditorInput) {
                    page.openEditor(input, "org.eclipse.scada.ca.ui.connection.editors.FactoryEditor", true);
                }
            }
            catch (PartInitException e) {
                status.add(e.getStatus());
            }
            ++n2;
        }
    }

    public static void handleOpen(IWorkbenchPage page, ISelectionProvider selectionProvider) {
        EditorHelper.handleOpen(page, selectionProvider.getSelection());
    }

    public static void handleOpen(IWorkbenchPage page, String connectionId, String factoryId, String configurationId) {
        try {
            page.openEditor((IEditorInput)new ConfigurationEditorInput(connectionId, factoryId, configurationId), "org.eclipse.scada.ca.ui.connection.editors.MultiConfigurationEditor", true);
        }
        catch (PartInitException e) {
            StatusManager.getManager().handle(e.getStatus());
        }
    }
}

