/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.editor.factory;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.scada.ca.data.ConfigurationInformation;
import org.eclipse.scada.ca.data.FactoryInformation;
import org.eclipse.scada.ca.ui.data.ConfigurationDescriptor;
import org.eclipse.scada.ca.ui.editor.EditorHelper;
import org.eclipse.scada.ca.ui.editor.factory.FactoryCellLabelProvider;
import org.eclipse.scada.ca.ui.editor.input.FactoryEditorInput;
import org.eclipse.scada.ca.ui.jobs.LoadFactoryJob;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class FactoryEditor
extends EditorPart {
    public static final String EDITOR_ID = "org.eclipse.scada.ca.ui.connection.editors.FactoryEditor";
    private TableViewer viewer;
    private FactoryInformation factory;
    private final Action deleteAction = new Action("Delete"){

        public void run() {
            FactoryEditor.this.handleDelete();
        }
    };
    private FactoryEditorInput factoryInput;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        try {
            this.setPartName(input.toString());
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(input);
        }
        catch (Exception e) {
            throw new PartInitException("Failed to initialize editor", (Throwable)e);
        }
    }

    protected void setInput(IEditorInput input) {
        this.factoryInput = (FactoryEditorInput)input;
        this.refresh();
        super.setInput(input);
    }

    public void refresh() {
        final LoadFactoryJob job = this.factoryInput.createLoadJob();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                FactoryEditor.this.handleSetResult(job.getFactory(), FactoryEditor.this.factoryInput.getConnectionUri());
            }
        });
        job.schedule();
    }

    protected void handleSetResult(final FactoryInformation factory, final String connectionUri) {
        final Display display = this.getSite().getShell().getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!display.isDisposed()) {
                        FactoryEditor.this.setResult(factory, connectionUri);
                    }
                }
            });
        }
    }

    protected void setResult(FactoryInformation factory, String connectionUri) {
        this.factory = factory;
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setInput((Object)this.convert(factory.getConfigurations(), connectionUri));
        }
    }

    private ConfigurationDescriptor[] convert(List<ConfigurationInformation> configurations, String connectionUri) {
        if (configurations == null) {
            return null;
        }
        ConfigurationDescriptor[] result = new ConfigurationDescriptor[configurations.size()];
        int i = 0;
        while (i < configurations.size()) {
            ConfigurationDescriptor newEntry = new ConfigurationDescriptor();
            ConfigurationInformation entry = configurations.get(i);
            newEntry.setConfigurationInformation(entry);
            newEntry.setConnectionUri(connectionUri);
            result[i] = newEntry;
            ++i;
        }
        return result;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        wrapper.setLayout((Layout)layout);
        this.viewer = new TableViewer(wrapper, 65538);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        TableLayout tableLayout = new TableLayout();
        this.viewer.getTable().setLayout((Layout)tableLayout);
        TableViewerColumn col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText("ID");
        col.setLabelProvider((CellLabelProvider)new FactoryCellLabelProvider());
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText("State");
        col.setLabelProvider((CellLabelProvider)new FactoryCellLabelProvider());
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FactoryEditor.this.handleDoubleClick(event);
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (this.factory != null) {
            this.viewer.setInput((Object)this.factory.getConfigurations());
        }
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ConfigurationDescriptor d1 = (ConfigurationDescriptor)e1;
                ConfigurationDescriptor d2 = (ConfigurationDescriptor)e2;
                return d1.getConfigurationInformation().getId().compareTo(d2.getConfigurationInformation().getId());
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookContextMenu(this.getEditorSite());
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        EditorHelper.handleOpen(this.getSite().getPage(), event.getSelection());
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void handleInsert() {
        InputDialog dlg = new InputDialog(this.getSite().getShell(), "Create new configuration", "Enter the id of the new configuration object to create", "", null);
        if (dlg.open() == 0) {
            this.insertEntry(dlg.getValue());
        }
    }

    private void insertEntry(String value) {
        Job job = this.factoryInput.createCreateJob(value);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                FactoryEditor.this.refresh();
            }
        });
        job.schedule();
    }

    public void handleDelete() {
        ISelection sel = this.viewer.getSelection();
        if (sel == null || sel.isEmpty() || !(sel instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        LinkedList<String> items = new LinkedList<String>();
        for (ConfigurationDescriptor info : selection) {
            items.add(info.getConfigurationInformation().getId());
        }
        if (items.isEmpty()) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.viewer.getControl().getShell(), (String)"Delete configurations", (String)String.format("Delete %s configuration entries", items.size()))) {
            return;
        }
        Job job = this.factoryInput.createDeleteJob(items);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                FactoryEditor.this.refresh();
            }
        });
        job.schedule();
    }

    private void hookContextMenu(IEditorSite editorSite) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FactoryEditor.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        editorSite.registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.deleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }
}

