/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.editor.input;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scada.ca.data.ConfigurationInformation;
import org.eclipse.scada.ca.ui.jobs.LoadJob;
import org.eclipse.scada.ca.ui.jobs.UpdateJob;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class ConfigurationEditorInput
implements IEditorInput {
    private final String factoryId;
    private final String configurationId;
    private final String connectionUri;
    private final WritableMap dataMap = new WritableMap();
    private final WritableValue dirtyValue = new WritableValue((Object)false, Boolean.class);

    public ConfigurationEditorInput(String connectionUri, String factoryId, String configurationId) {
        this.connectionUri = connectionUri;
        this.factoryId = factoryId;
        this.configurationId = configurationId;
        this.dataMap.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                ConfigurationEditorInput.this.dirtyValue.setValue((Object)true);
            }
        });
    }

    public String getConnectionUri() {
        return this.connectionUri;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public String toString() {
        return String.valueOf(this.factoryId) + "/" + this.configurationId;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.toString();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.toString();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void performLoad(IProgressMonitor monitor) {
        final LoadJob job = this.load();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ConfigurationEditorInput.this.handleSetResult(job.getConfiguration());
            }
        });
        job.setProgressGroup(monitor, 2);
        job.schedule();
    }

    protected void setResult(ConfigurationInformation configurationInformation) {
        this.dataMap.setStale(true);
        this.dataMap.clear();
        if (configurationInformation != null) {
            this.dataMap.putAll(configurationInformation.getData());
        }
        this.dataMap.setStale(false);
        this.dirtyValue.setValue((Object)false);
    }

    protected void handleSetResult(final ConfigurationInformation configurationInformation) {
        Realm realm = this.dataMap.getRealm();
        realm.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ConfigurationEditorInput.this.dataMap.isDisposed()) {
                    ConfigurationEditorInput.this.setResult(configurationInformation);
                }
            }
        });
    }

    public void performSave(final IProgressMonitor monitor) {
        UpdateJob updateJob = this.update(new HashMap<String, String>((Map<String, String>)this.dataMap), null);
        updateJob.setProgressGroup(monitor, 2);
        updateJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ConfigurationEditorInput.this.performLoad(monitor);
            }
        });
        updateJob.schedule();
    }

    protected LoadJob load() {
        return new LoadJob(this.connectionUri, this.factoryId, this.configurationId);
    }

    protected UpdateJob update(Map<String, String> addedOrUpdated, Set<String> removed) {
        return new UpdateJob(this.connectionUri, this.factoryId, this.configurationId, addedOrUpdated, removed);
    }

    public void updateEntry(String oldKey, String key, String value) {
        this.dataMap.setStale(true);
        this.dataMap.remove((Object)oldKey);
        this.dataMap.put((Object)key, (Object)value);
        this.dataMap.setStale(false);
        this.dirtyValue.setValue((Object)true);
    }

    public void insertEntry(String key, String value) {
        this.dataMap.put((Object)key, (Object)value);
        this.dirtyValue.setValue((Object)true);
    }

    public void deleteEntry(String key) {
        this.dataMap.remove((Object)key);
        this.dirtyValue.setValue((Object)true);
    }

    public WritableMap getDataMap() {
        return this.dataMap;
    }

    public WritableValue getDirtyValue() {
        return this.dirtyValue;
    }

    public String getFactoryId() {
        return this.factoryId;
    }
}

