/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.dataitem.details.part.attrs;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.client.dataitem.details.part.AbstractBaseDetailsPart;
import org.eclipse.scada.da.client.dataitem.details.part.attrs.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class AttributesPart
extends AbstractBaseDetailsPart {
    private final WritableSet entries = new WritableSet();
    private TableViewer viewer;

    @Override
    public void createPart(Composite parent) {
        super.createPart(parent);
        this.viewer = new TableViewer(parent, 65536);
        TableLayout tableLayout = new TableLayout();
        TableViewerColumn col1 = new TableViewerColumn(this.viewer, 0);
        col1.getColumn().setText(Messages.AttributesPart_NameLabel);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        TableViewerColumn col2 = new TableViewerColumn(this.viewer, 0);
        col2.getColumn().setText(Messages.AttributesPart_TypeLabel);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        TableViewerColumn col3 = new TableViewerColumn(this.viewer, 0);
        col3.getColumn().setText(Messages.AttributesPart_ValueLabel);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLayout((Layout)tableLayout);
        ViewerSupport.bind((StructuredViewer)this.viewer, (IObservableSet)this.entries, (IValueProperty[])new IValueProperty[]{PojoProperties.value((String)"name"), PojoProperties.value((String)"type"), PojoProperties.value((String)"value")});
        this.viewer.setComparator(new ViewerComparator());
    }

    @Override
    public void dispose() {
        this.entries.dispose();
        super.dispose();
    }

    @Override
    protected void update() {
        Set<Entry> newAttributes = this.convert(this.getValue());
        SetDiff diff = Diffs.computeSetDiff((Set)this.entries, newAttributes);
        diff.applyTo((Set)this.entries);
    }

    private Set<Entry> convert(DataItemValue value) {
        if (value == null || value.getAttributes() == null) {
            return Collections.emptySet();
        }
        HashSet<Entry> entries = new HashSet<Entry>(value.getAttributes().size());
        for (Map.Entry entry : value.getAttributes().entrySet()) {
            Variant entryValue = (Variant)entry.getValue();
            if (entryValue != null) {
                entries.add(new Entry((String)entry.getKey(), entryValue.getType().toString(), entryValue.toLabel()));
                continue;
            }
            entries.add(new Entry((String)entry.getKey(), null, null));
        }
        return entries;
    }

    public static class Entry {
        private final String name;
        private final String type;
        private final String value;

        public Entry(String name, String type, String value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getType() {
            return this.type;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

