/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.common;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.connection.data.ItemSelectionHelper;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public abstract class AbstractItemAction
implements IObjectActionDelegate {
    protected final Collection<Item> items = new LinkedList<Item>();
    protected IWorkbenchPage page;
    private final String message;

    public AbstractItemAction(String message) {
        this.message = message;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.page = targetPart.getSite().getPage();
    }

    protected abstract void processItem(Item var1) throws PartInitException;

    public void run(IAction action) {
        MultiStatus status = new MultiStatus("org.eclipse.scada.da.ui.common", 0, this.message, null);
        for (Item item : this.items) {
            try {
                this.processItem(item);
            }
            catch (PartInitException e) {
                status.add(e.getStatus());
            }
        }
        if (!status.isOK()) {
            this.showError(status);
        }
    }

    protected void showError(MultiStatus status) {
        ErrorDialog.openError((Shell)this.page.getWorkbenchWindow().getShell(), (String)"View Error", (String)"Failed to show data item details", (IStatus)status);
    }

    protected String asSecondardId(Item item) {
        return item.getId().replace("_", "__").replace(':', '_');
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.clearSelection();
        this.items.addAll(ItemSelectionHelper.getSelection((ISelection)selection));
    }

    protected void clearSelection() {
        this.items.clear();
    }
}

