/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.ui.connection.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.ui.connection.internal.ItemListWrapper;
import org.eclipse.scada.hd.ui.connection.internal.ItemWrapper;
import org.eclipse.scada.hd.ui.connection.internal.QueryBufferBean;
import org.eclipse.scada.hd.ui.connection.internal.QueryWrapper;
import org.eclipse.scada.hd.ui.connection.views.Messages;
import org.eclipse.scada.hd.ui.data.QueryBuffer;
import org.eclipse.scada.ui.databinding.CommonListeningLabelProvider;
import org.eclipse.scada.ui.databinding.StyledViewerLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionLabelProvider
extends CommonListeningLabelProvider
implements PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionLabelProvider.class);
    private final ResourceManager resource = new LocalResourceManager(JFaceResources.getResources());

    public ConnectionLabelProvider() {
        super("org.eclipse.scada.hd.ui.connection.provider");
    }

    public void dispose() {
        this.resource.dispose();
        super.dispose();
    }

    public void updateLabel(StyledViewerLabel label, Object element) {
        if (element instanceof ItemWrapper) {
            this.updateItem(label, (ItemWrapper)((Object)element));
        } else if (element instanceof ItemListWrapper) {
            label.setImage(this.resource.createImage(ImageDescriptor.createFromFile(ConnectionLabelProvider.class, (String)"icons/items.gif")));
            label.setText(Messages.ConnectionLabelProvider_Items);
        } else if (element instanceof QueryWrapper) {
            label.setImage(this.resource.createImage(ImageDescriptor.createFromFile(ConnectionLabelProvider.class, (String)"icons/queries.gif")));
            label.setText(Messages.ConnectionLabelProvider_Queries);
        } else if (element instanceof QueryBufferBean) {
            this.updateQuery(label, (QueryBufferBean)((Object)element));
        } else {
            super.updateLabel(label, element);
        }
    }

    private void updateQuery(StyledViewerLabel label, QueryBufferBean query) {
        label.setImage(this.resource.createImage(ImageDescriptor.createFromFile(ConnectionLabelProvider.class, (String)"icons/query.gif")));
        StyledString text = new StyledString();
        text.append(query.getItemId());
        text.append(" " + this.getQueryParameterInfo(query), StyledString.COUNTER_STYLER);
        QueryState state = query.getState();
        text.append(" [" + (state != null ? state : "<unknown>") + "]", StyledString.DECORATIONS_STYLER);
        label.setStyledText(text);
    }

    private String getQueryParameterInfo(QueryBufferBean query) {
        QueryParameters parameters = query.getQueryParameters();
        if (parameters != null) {
            return parameters.toString();
        }
        return "";
    }

    private void updateItem(StyledViewerLabel label, ItemWrapper element) {
        label.setText(element.getItemInformation().getItemId());
        label.setImage(this.resource.createImage(ImageDescriptor.createFromFile(ConnectionLabelProvider.class, (String)"icons/item.gif")));
    }

    protected void addListenerTo(Object next) {
        super.addListenerTo(next);
        if (next instanceof QueryBufferBean) {
            logger.debug("Adding query: {}", next);
            ((QueryBufferBean)((Object)next)).addPropertyChangeListener(this);
            this.fireChangeEvent(Arrays.asList(next));
        }
    }

    protected void removeListenerFrom(Object next) {
        if (next instanceof QueryBufferBean) {
            ((QueryBufferBean)((Object)next)).removePropertyChangeListener(this);
        }
        super.removeListenerFrom(next);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName;
        logger.debug("Property change: {}");
        if (evt.getSource() instanceof QueryBuffer && !"percentFilled".equals(propName = evt.getPropertyName()) && !"filled".equals(propName)) {
            this.fireChangeEvent(Arrays.asList(evt.getSource()));
        }
    }
}

