/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.ui.connection.views;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.scada.hd.ItemListListener;
import org.eclipse.scada.hd.connection.provider.ConnectionService;
import org.eclipse.scada.hd.data.HistoricalItemInformation;
import org.eclipse.scada.hd.ui.connection.internal.ConnectionWrapper;
import org.eclipse.scada.hd.ui.connection.internal.ItemWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemListObserver
extends WritableSet
implements ItemListListener {
    private static final Logger logger = LoggerFactory.getLogger(ItemListObserver.class);
    private final ConnectionService service;
    private final ConnectionWrapper connection;
    private final Map<String, ItemWrapper> items = new HashMap<String, ItemWrapper>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemListObserver(ConnectionWrapper connection) {
        this.connection = connection;
        this.service = connection.getService();
        ItemListObserver itemListObserver = this;
        synchronized (itemListObserver) {
            this.service.getConnection().addListListener((ItemListListener)this);
        }
    }

    public synchronized void dispose() {
        this.service.getConnection().removeListListener((ItemListListener)this);
        super.dispose();
    }

    public void listChanged(final Set<HistoricalItemInformation> addedOrModified, final Set<String> removed, final boolean full) {
        logger.debug("List changed: {} / {}", new Object[]{addedOrModified, removed});
        if (!this.isDisposed()) {
            this.getRealm().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ItemListObserver.this.handleUpdate(addedOrModified, removed, full);
                }
            });
        }
    }

    protected void handleUpdate(Set<HistoricalItemInformation> addedOrModified, Set<String> removed, boolean full) {
        if (this.isDisposed()) {
            return;
        }
        this.setStale(true);
        try {
            if (full) {
                this.clear();
            }
            if (removed != null) {
                for (String itemId : removed) {
                    ItemWrapper info = this.items.remove(itemId);
                    if (info == null) continue;
                    this.remove((Object)info);
                }
            }
            if (addedOrModified != null) {
                for (HistoricalItemInformation item : addedOrModified) {
                    ItemWrapper wrapper = new ItemWrapper(this.connection, item);
                    this.items.put(item.getItemId(), wrapper);
                    this.add((Object)wrapper);
                }
            }
        }
        finally {
            this.setStale(false);
        }
    }
}

