/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.testing.navigator;

import java.util.List;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.Query;
import org.eclipse.scada.ae.QueryListener;
import org.eclipse.scada.ae.data.QueryState;
import org.eclipse.scada.ae.ui.testing.navigator.QueryListWrapper;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBean
extends AbstractPropertyChange
implements QueryListener {
    private static final Logger logger = LoggerFactory.getLogger(QueryBean.class);
    private static final String PROP_STATE = "state";
    private static final String PROP_COUNT = "count";
    private final String filterData;
    private final String filterType;
    private QueryState state;
    private Query query;
    private final WritableSet events = new WritableSet();
    private final QueryListWrapper wrapper;

    public QueryBean(QueryListWrapper wrapper, String filterType, String filterData) {
        this.wrapper = wrapper;
        this.filterType = filterType;
        this.filterData = filterData;
    }

    public String getFilterData() {
        return this.filterData;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public void queryData(final List<Event> events) {
        logger.debug("Received {} events", (Object)events.size());
        this.events.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                QueryBean.this.addData(events);
            }
        });
    }

    protected void addData(List<Event> events) {
        long tix = System.currentTimeMillis();
        int oldSize = this.events.size();
        this.events.addAll(events);
        int newSize = this.events.size();
        logger.debug("String delta: {}", (Object)(System.currentTimeMillis() - tix));
        this.firePropertyChange(PROP_COUNT, oldSize, newSize);
    }

    public int getCount() {
        return this.events.size();
    }

    public void queryStateChanged(QueryState state, Throwable error) {
        logger.info("Query state changed {}: ", (Object)state, (Object)(error != null ? error.getMessage() : "<none>"));
        QueryState oldState = this.state;
        this.state = state;
        this.firePropertyChange(PROP_STATE, oldState, state);
    }

    public void setController(Query createQuery) {
        this.query = createQuery;
    }

    public QueryState getState() {
        return this.state;
    }

    public Query getQuery() {
        return this.query;
    }

    public void remove() {
        this.query.close();
        this.wrapper.remove(this);
    }

    public void dispose() {
        this.query.close();
    }

    public IObservableSet getEventObservable() {
        return Observables.proxyObservableSet((IObservableSet)this.events);
    }
}

