/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.testing.views;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.ui.connection.data.MonitorStatusBean;
import org.eclipse.scada.ae.ui.testing.views.AbstractConditionQueryViewPart;
import org.eclipse.scada.ae.ui.testing.views.MonitorsLabelProvider;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorsView
extends AbstractConditionQueryViewPart {
    private static final Logger logger = LoggerFactory.getLogger(MonitorsView.class);
    public static final String VIEW_ID = "org.eclipse.scada.ae.ui.testing.views.MonitorsView";
    private Label stateLabel;
    private final Map<String, MonitorStatusBean> monitorSet = new HashMap<String, MonitorStatusBean>();
    private final WritableSet monitors = new WritableSet(SWTObservables.getRealm((Display)Display.getDefault()));
    private TableViewer viewer;

    @Override
    protected Realm getRealm() {
        return this.monitors.getRealm();
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.stateLabel = new Label(parent, 0);
        this.stateLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TableViewer(wrapper, 65538);
        TableColumnLayout tableLayout = new TableColumnLayout();
        wrapper.setLayout((Layout)tableLayout);
        TableColumn col = new TableColumn(this.viewer.getTable(), 0);
        col.setText("ID");
        tableLayout.setColumnData((Widget)col, (ColumnLayoutData)new ColumnWeightData(50));
        col = new TableColumn(this.viewer.getTable(), 0);
        col.setText("State");
        tableLayout.setColumnData((Widget)col, (ColumnLayoutData)new ColumnWeightData(50));
        col = new TableColumn(this.viewer.getTable(), 0);
        col.setText("Change Timestamp");
        tableLayout.setColumnData((Widget)col, (ColumnLayoutData)new ColumnWeightData(100));
        col = new TableColumn(this.viewer.getTable(), 0);
        col.setText("Priority");
        tableLayout.setColumnData((Widget)col, (ColumnLayoutData)new ColumnWeightData(50));
        col = new TableColumn(this.viewer.getTable(), 0);
        col.setText("Value");
        tableLayout.setColumnData((Widget)col, (ColumnLayoutData)new ColumnWeightData(50));
        col = new TableColumn(this.viewer.getTable(), 0);
        col.setText("Ack User");
        tableLayout.setColumnData((Widget)col, (ColumnLayoutData)new ColumnWeightData(50));
        col = new TableColumn(this.viewer.getTable(), 0);
        col.setText("Ack Timestamp");
        tableLayout.setColumnData((Widget)col, (ColumnLayoutData)new ColumnWeightData(100));
        this.viewer.getTable().setLayout((Layout)layout);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof MonitorStatusBean && e2 instanceof MonitorStatusBean) {
                    MonitorStatusBean b1 = (MonitorStatusBean)e1;
                    MonitorStatusBean b2 = (MonitorStatusBean)e2;
                    return b1.getId().compareTo(b2.getId());
                }
                return 0;
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ObservableSetContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MonitorsLabelProvider(BeansObservables.observeMaps((IObservableSet)this.monitors, MonitorStatusBean.class, (String[])new String[]{"id", "status", "statusTimestamp", "value", "lastAknUser", "lastAknTimestamp", "lastFailTimestamp", "attributes"})));
        this.viewer.setInput((Object)this.monitors);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookContextMenu();
        this.addSelectionListener();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu", VIEW_ID);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MonitorsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    @Override
    protected void clear() {
        super.clear();
        this.scheduleJob(new Runnable(){

            @Override
            public void run() {
                MonitorsView.this.monitorSet.clear();
                MonitorsView.this.monitors.clear();
                MonitorsView.this.stateLabel.setText("<no query selected>");
            }
        });
    }

    @Override
    public void handleDataChanged(final List<MonitorStatusInformation> addedOrUpdated, final Set<String> removed, final boolean full) {
        this.scheduleJob(new Runnable(){

            @Override
            public void run() {
                MonitorsView.this.performDataChanged(addedOrUpdated, removed, full);
            }
        });
    }

    protected void performDataChanged(List<MonitorStatusInformation> addedOrUpdated, Set<String> removed, boolean full) {
        logger.debug("Got data change");
        try {
            if (full) {
                this.monitors.clear();
            }
            LinkedList<MonitorStatusBean> infos = new LinkedList<MonitorStatusBean>();
            if (removed != null) {
                for (String id : removed) {
                    MonitorStatusBean info = this.monitorSet.remove(id);
                    if (info == null) continue;
                    infos.add(info);
                }
            }
            this.monitors.removeAll(infos);
            infos = new LinkedList();
            if (addedOrUpdated != null) {
                for (MonitorStatusInformation info : addedOrUpdated) {
                    MonitorStatusBean infoBean;
                    if (this.monitorSet.containsKey(info.getId())) {
                        infoBean = this.monitorSet.get(info.getId());
                        infoBean.update(info);
                        continue;
                    }
                    infoBean = new MonitorStatusBean(this.entry.getConnection(), info);
                    this.monitorSet.put(info.getId(), infoBean);
                    infos.add(infoBean);
                }
            }
            this.monitors.addAll(infos);
        }
        catch (Throwable e) {
            logger.warn("Failed to handle data", e);
        }
    }

    @Override
    public void handleStatusChanged(SubscriptionState status) {
        this.triggerStateUpdate(status);
    }

    private void triggerStateUpdate(final SubscriptionState status) {
        if (this.stateLabel.isDisposed()) {
            return;
        }
        this.scheduleJob(new Runnable(){

            @Override
            public void run() {
                if (MonitorsView.this.stateLabel.isDisposed()) {
                    return;
                }
                MonitorsView.this.stateLabel.setText(status.toString());
            }
        });
    }
}

