/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.view;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scada.ui.chart.model.Chart;
import org.eclipse.scada.ui.chart.model.provider.ChartItemProviderAdapterFactory;
import org.eclipse.scada.ui.chart.view.AbstractChartManagePart;
import org.eclipse.scada.ui.chart.view.ChartActionBarContributor;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class ChartConfiguratorView
extends AbstractChartManagePart
implements IViewerProvider,
IEditingDomainProvider,
IMenuListener {
    private TreeViewer viewer;
    private ComposedAdapterFactory factory;
    private ExtendedPropertySheetPage propertySheetPage;
    private AdapterFactoryEditingDomain editingDomain;
    private Composite container;
    private ChartActionBarContributor actionBarContributor;

    private void createEditingDomain() {
        BasicCommandStack commandStack = new BasicCommandStack();
        this.factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.factory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.factory.addAdapterFactory((AdapterFactory)new ChartItemProviderAdapterFactory());
        this.factory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                ChartConfiguratorView.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ChartConfiguratorView.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            ChartConfiguratorView.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        if (ChartConfiguratorView.this.propertySheetPage != null && !ChartConfiguratorView.this.propertySheetPage.getControl().isDisposed()) {
                            ChartConfiguratorView.this.propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.factory, (CommandStack)commandStack, new HashMap());
        this.actionBarContributor = new ChartActionBarContributor();
    }

    public void dispose() {
        this.actionBarContributor.dispose();
        this.factory.dispose();
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        super.dispose();
    }

    @Override
    protected void setChartViewer(ChartViewer chartViewer) {
        if (chartViewer == null) {
            this.viewer.setInput(null);
        } else {
            Chart element = chartViewer.getChartConfiguration();
            if (element.eResource().getURI() == null) {
                element.eResource().setURI(URI.createURI((String)"urn:dummy"));
            }
            this.viewer.setInput((Object)element.eResource());
        }
    }

    protected Composite getContainer() {
        return this.container;
    }

    public void createPartControl(Composite parent) {
        this.container = parent;
        this.createEditingDomain();
        parent.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(parent);
        this.viewer.setAutoExpandLevel(2);
        this.viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.factory));
        this.viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.factory));
        this.createContextMenuFor((StructuredViewer)this.viewer);
        new AdapterFactoryTreeEditor(this.viewer.getTree(), (AdapterFactory)this.factory);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.attachSelectionService();
        this.getViewSite().getActionBars().getMenuManager().add((IContributionItem)new Separator("additions"));
        this.actionBarContributor.init(this.getViewSite().getActionBars());
        this.actionBarContributor.setViewPart((IViewPart)this);
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(7, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(7, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(adapter);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (ChartConfiguratorView.this.viewer != null) {
                        ChartConfiguratorView.this.viewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

                public void setSelectionToViewer(List<?> selection) {
                    ChartConfiguratorView.this.setSelectionToViewer(selection);
                    ChartConfiguratorView.this.setFocus();
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.factory));
        }
        return this.propertySheetPage;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.actionBarContributor.menuAboutToShow(manager);
    }
}

