/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.view.command;

import java.util.Arrays;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.hd.ui.connection.data.Item;
import org.eclipse.scada.ui.chart.model.Chart;
import org.eclipse.scada.ui.chart.model.ChartFactory;
import org.eclipse.scada.ui.chart.model.Charts;
import org.eclipse.scada.ui.chart.model.CompositeArchiveQualitySeries;
import org.eclipse.scada.ui.chart.view.command.AbstractChartHandler;

public class OpenChartViewWithParameters
extends AbstractChartHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String connectionId = event.getParameter("org.eclipse.scada.ui.chart.connectionId");
        String connectionString = event.getParameter("org.eclipse.scada.ui.chart.connectionString");
        String itemId = event.getParameter("org.eclipse.scada.ui.chart.itemId");
        String itemType = event.getParameter("org.eclipse.scada.ui.chart.itemType");
        if (connectionId == null && connectionString == null) {
            throw new ExecutionException("No connection ID or string set");
        }
        if (itemType == null) {
            throw new ExecutionException("Item type is not set");
        }
        Chart configuration = this.makeConfiguration(event);
        if ("da".equals(itemType)) {
            this.openDaChartView(Arrays.asList(new Item(connectionId != null ? connectionId : connectionString, itemId, connectionId != null ? Item.Type.ID : Item.Type.URI)), configuration);
        } else if ("hd".equals(itemType)) {
            this.openHdChartView(Arrays.asList(new org.eclipse.scada.hd.ui.connection.data.Item(connectionId != null ? connectionId : connectionString, itemId, connectionId != null ? Item.Type.ID : Item.Type.URI)), configuration);
        } else {
            throw new ExecutionException(String.format("The item type '%s' is unsupported", itemType));
        }
        return null;
    }

    private Chart makeConfiguration(ExecutionEvent event) {
        String queryTimespec = event.getParameter("org.eclipse.scada.ui.chart.queryTimespec");
        Chart configuration = Charts.makeDefaultConfiguration();
        if (queryTimespec != null && !queryTimespec.isEmpty()) {
            String[] toks = queryTimespec.split("[: ]+");
            long now = System.currentTimeMillis();
            int left = Integer.parseInt(toks[0]);
            int right = Integer.parseInt(toks[1]);
            configuration.getSelectedXAxis().setMinimum(now - (long)left);
            configuration.getSelectedXAxis().setMaximum(now + (long)right);
            if (toks.length >= 4) {
                double min = Double.parseDouble(toks[2]);
                double max = Double.parseDouble(toks[3]);
                configuration.getSelectedYAxis().setMinimum(min);
                configuration.getSelectedYAxis().setMaximum(max);
            }
        }
        CompositeArchiveQualitySeries q = ChartFactory.eINSTANCE.createCompositeArchiveQualitySeries();
        q.setX(configuration.getSelectedXAxis());
        q.setY(configuration.getSelectedYAxis());
        q.setVisible(true);
        q.setThreshold(0.75);
        configuration.getInputs().add((Object)q);
        return configuration;
    }
}

