/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.ui.chart.model.YAxis;
import org.eclipse.scada.ui.chart.viewer.AbstractAxisManager;
import org.eclipse.scada.ui.chart.viewer.YAxisViewer;

public class YAxisManager
extends AbstractAxisManager<YAxis, YAxisViewer> {
    private final Map<YAxis, YAxisViewer> axisMap = new HashMap<YAxis, YAxisViewer>(1);
    private final boolean left;

    public YAxisManager(DataBindingContext dbc, ChartRenderer manager, boolean left) {
        super(dbc, manager);
        this.left = left;
    }

    @Override
    protected void handleAdd(int index, YAxis axis) {
        YAxisViewer viewer = new YAxisViewer(this.dbc, this.manager, axis, this.left);
        this.axisMap.put(axis, viewer);
    }

    @Override
    protected void handleRemove(YAxis axis) {
        YAxisViewer viewer = this.axisMap.remove(axis);
        if (viewer != null) {
            viewer.dispose();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        for (YAxisViewer viewer : this.axisMap.values()) {
            viewer.dispose();
        }
        this.axisMap.clear();
    }

    @Override
    public YAxisViewer getAxis(YAxis axis) {
        return this.axisMap.get(axis);
    }

    @Override
    public Collection<YAxisViewer> getAll() {
        return this.axisMap.values();
    }
}

