/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.controller.actions;

import org.eclipse.scada.ui.chart.model.TimeNowAction;
import org.eclipse.scada.ui.chart.model.XAxisController;
import org.eclipse.scada.ui.chart.viewer.ChartContext;
import org.eclipse.scada.ui.chart.viewer.XAxisViewer;
import org.eclipse.scada.ui.chart.viewer.controller.ChartController;
import org.eclipse.scada.ui.chart.viewer.controller.ControllerManager;
import org.eclipse.scada.ui.chart.viewer.controller.actions.AbstractXAxisController;
import org.eclipse.scada.ui.chart.viewer.controller.actions.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class TimeNowActionController
extends AbstractXAxisController
implements ChartController {
    private Button button;
    private long milliseconds;

    public TimeNowActionController(ControllerManager controllerManager, ChartContext chartContext, TimeNowAction controller) {
        super(controllerManager.getContext(), chartContext, (XAxisController)controller);
        Composite space = chartContext.getExtensionSpaceProvider().getExtensionSpace();
        if (space != null) {
            this.button = new Button(space, 8);
            this.button.setText(Messages.TimeNowActionController_Label);
            this.button.setToolTipText(Messages.TimeNowActionController_Description);
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TimeNowActionController.this.action();
                }
            });
            space.layout();
        } else {
            this.button = null;
        }
    }

    protected void action() {
        long now = System.currentTimeMillis();
        for (XAxisViewer viewer : this.getCurrentViewers()) {
            viewer.getAxis().setCenter(now);
        }
    }

    @Override
    public void dispose() {
        if (this.button != null) {
            this.button.dispose();
        }
        super.dispose();
    }

    public void setMilliseconds(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }
}

