/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.input;

import java.util.Date;
import java.util.HashMap;
import javax.script.ScriptContext;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.chart.AsyncFunctionSeriesData;
import org.eclipse.scada.chart.DataEntry;
import org.eclipse.scada.chart.Realm;
import org.eclipse.scada.chart.SeriesData;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.chart.swt.render.AbstractLineRender;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.scada.chart.swt.render.StepRenderer;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.scada.ui.chart.viewer.input.LineInput;
import org.eclipse.scada.utils.script.ScriptExecutor;

public class ScriptInput
extends LineInput {
    private AbstractLineRender renderer;
    private ChartViewer viewer;
    private String script;
    private ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    private ScriptExecutor scriptExecutor;
    private AsyncFunctionSeriesData dataSeries;

    public ScriptInput(ChartViewer viewer, Realm realm, ResourceManager resourceManager, XAxis xAxis, YAxis yAxis) {
        super(resourceManager);
        this.viewer = viewer;
        this.dataSeries = new AsyncFunctionSeriesData(realm, xAxis, yAxis, 0){

            protected Double eval(long timestamp) {
                return ScriptInput.this.handleEval(timestamp);
            }
        };
        this.renderer = new StepRenderer(viewer.getChartRenderer(), (SeriesData)this.dataSeries);
        viewer.getChartRenderer().addRenderer((Renderer)this.renderer);
        this.attachHover(viewer, xAxis);
    }

    protected Double handleEval(long timestamp) {
        Object result;
        block5: {
            if (this.scriptExecutor == null) {
                return null;
            }
            SimpleScriptContext context = new SimpleScriptContext();
            context.setAttribute("timestamp", timestamp, 200);
            try {
                HashMap<String, Long> var = new HashMap<String, Long>(1);
                var.put("timestamp", timestamp);
                result = this.scriptExecutor.execute((ScriptContext)context, var);
                if (result != null) break block5;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        return Double.parseDouble(result.toString());
    }

    @Override
    public void dispose() {
        this.viewer.getChartRenderer().removeRenderer((Renderer)this.renderer);
        this.renderer.dispose();
        super.dispose();
    }

    public void setScript(String script) {
        this.script = script;
        try {
            this.scriptExecutor = null;
            this.scriptExecutor = new ScriptExecutor(this.scriptEngineManager, "JavaScript", script, this.getClass().getClassLoader());
            this.dataSeries.regenerate();
            this.firePropertyChange("state", null, this.getState());
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getScript() {
        return this.script;
    }

    @Override
    public void setSelection(boolean state) {
    }

    @Override
    protected void setSelectedTimestamp(Date selectedTimestamp) {
        super.setSelectedTimestamp(selectedTimestamp);
        DataEntry value = this.dataSeries.getViewData().getEntries().lower(new DataEntry(selectedTimestamp.getTime(), null));
        if (value == null) {
            this.setSelectedValue(null);
        } else {
            this.setSelectedValue(value.toString());
        }
    }

    @Override
    public void tick(long now) {
    }

    @Override
    public String getState() {
        return this.scriptExecutor == null ? "invalid" : "valid";
    }

    @Override
    protected AbstractLineRender getLineRenderer() {
        return this.renderer;
    }
}

