/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.discoverer.file;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scada.core.ui.connection.ConnectionDescriptor;
import org.eclipse.scada.core.ui.connection.ConnectionStore;
import org.eclipse.scada.core.ui.connection.discoverer.file.Activator;
import org.eclipse.scada.core.ui.connection.discoverer.file.Messages;
import org.eclipse.scada.core.ui.connection.discoverer.file.ResourceDiscoverer;

public class DefaultFileResourceDiscoverer
extends ResourceDiscoverer
implements ConnectionStore {
    private static final String FILENAME = "connections.txt";

    @Override
    protected void initialize() {
        this.load(this.getFile());
    }

    public void add(ConnectionDescriptor connectionInformation) throws CoreException {
        if (this.addConnection(connectionInformation)) {
            this.store();
        }
    }

    public void remove(ConnectionDescriptor connectionInformation) throws CoreException {
        if (this.removeConnection(connectionInformation)) {
            this.store();
        }
    }

    public void update(ConnectionDescriptor oldConnectionDescriptor, ConnectionDescriptor newConnectionDescriptor) throws CoreException {
        this.remove(oldConnectionDescriptor);
        this.add(newConnectionDescriptor);
    }

    private void store() throws CoreException {
        PrintWriter printer = null;
        try {
            try {
                printer = new PrintWriter(this.getFile());
                for (ConnectionDescriptor descriptor : this.getConnections()) {
                    if (descriptor.getServiceId() != null) {
                        printer.println(String.valueOf(descriptor.getServiceId()) + "*" + descriptor.getConnectionInformation());
                        continue;
                    }
                    printer.println(descriptor.getConnectionInformation().toString());
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.scada.core.ui.connection.discoverer.file", Messages.DefaultFileResourceDiscoverer_ErrorStore, (Throwable)e));
            }
        }
        finally {
            if (printer != null) {
                printer.close();
            }
        }
    }

    private File getFile() {
        return Activator.getDefault().getBundle().getBundleContext().getDataFile(FILENAME);
    }
}

