/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.information;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scada.core.connection.provider.info.ConnectionInformationProvider;
import org.eclipse.scada.core.ui.connection.information.InformationBean;
import org.eclipse.scada.core.ui.connection.information.Messages;
import org.eclipse.scada.ui.databinding.ListeningStyledCellLabelProvider;

public class LabelProvider
extends ListeningStyledCellLabelProvider
implements PropertyChangeListener {
    public LabelProvider(IObservableSet itemsThatNeedLabels) {
        super(itemsThatNeedLabels);
    }

    public void update(ViewerCell cell) {
        if (cell.getElement() instanceof ConnectionInformationProvider) {
            ConnectionInformationProvider provider = (ConnectionInformationProvider)cell.getElement();
            switch (cell.getColumnIndex()) {
                case 0: {
                    cell.setText(provider.getLabel());
                }
            }
        } else if (cell.getElement() instanceof InformationBean) {
            InformationBean bean = (InformationBean)cell.getElement();
            switch (cell.getColumnIndex()) {
                case 0: {
                    cell.setText(bean.getLabel());
                    break;
                }
                case 1: {
                    cell.setText(this.format(bean.getValue()));
                    break;
                }
                case 2: {
                    cell.setText(this.format(bean.getMin()));
                    break;
                }
                case 3: {
                    cell.setText(this.format(bean.getMax()));
                }
            }
        }
        super.update(cell);
    }

    private String format(Number number) {
        if (number == null) {
            return Messages.LabelProvider_Text_NA;
        }
        return NumberFormat.getNumberInstance().format(number.doubleValue());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, evt.getSource()));
    }

    protected void removeListenerFrom(Object next) {
        if (next instanceof InformationBean) {
            ((InformationBean)next).removePropertyChangeListener(this);
        }
    }

    protected void addListenerTo(Object next) {
        if (next instanceof InformationBean) {
            ((InformationBean)next).addPropertyChangeListener(this);
        }
    }
}

