/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.information.details;

import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.connection.provider.info.ConnectionInformationProvider;
import org.eclipse.scada.core.ui.connection.information.ConnectionInformationWrapper;
import org.eclipse.scada.core.ui.connection.information.InformationBeanComparator;
import org.eclipse.scada.core.ui.connection.information.LabelProvider;
import org.eclipse.scada.core.ui.connection.information.details.DetailsTab;
import org.eclipse.scada.core.ui.connection.information.details.Messages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class StatisticsTab
implements DetailsTab {
    private TabItem item;
    private ConnectionInformationWrapper wrapper;
    private Object provider;
    private TableViewer viewer;
    private ObservableSetContentProvider contentProvider;

    @Override
    public void setSelection(ConnectionService connectionService) {
        if (connectionService instanceof ConnectionInformationProvider) {
            this.setProvider((ConnectionInformationProvider)connectionService);
        }
    }

    private void setProvider(ConnectionInformationProvider provider) {
        if (this.wrapper != null) {
            this.viewer.setInput(null);
            this.wrapper.dispose();
            this.wrapper = null;
        }
        this.provider = provider;
        if (this.provider != null) {
            this.wrapper = new ConnectionInformationWrapper(provider);
            this.viewer.setInput((Object)this.wrapper);
        }
    }

    protected void handleDispose() {
        this.setProvider(null);
    }

    @Override
    public void createTab(TabFolder tabFolder) {
        this.item = new TabItem(tabFolder, 0);
        this.item.setText(Messages.StatisticsTab_TabItem_Label);
        this.item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StatisticsTab.this.handleDispose();
            }
        });
        this.viewer = new TableViewer((Composite)tabFolder, 66304);
        this.contentProvider = new ObservableSetContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.getTable().setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        this.viewer.getTable().setLayout((Layout)layout);
        TableViewerColumn col = new TableViewerColumn(this.viewer, 0);
        col.setLabelProvider((CellLabelProvider)new LabelProvider(this.contentProvider.getRealizedElements()));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        col = new TableViewerColumn(this.viewer, 0);
        col.setLabelProvider((CellLabelProvider)new LabelProvider(this.contentProvider.getRealizedElements()));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        col.getColumn().setText(Messages.StatisticsTab_Col_Current_Label);
        col = new TableViewerColumn(this.viewer, 0);
        col.setLabelProvider((CellLabelProvider)new LabelProvider(this.contentProvider.getRealizedElements()));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        col.getColumn().setText(Messages.StatisticsTab_Col_Min_Label);
        col = new TableViewerColumn(this.viewer, 0);
        col.setLabelProvider((CellLabelProvider)new LabelProvider(this.contentProvider.getRealizedElements()));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        col.getColumn().setText(Messages.StatisticsTab_Col_Max_Label);
        this.viewer.setComparator((ViewerComparator)new InformationBeanComparator());
        this.item.setControl(this.viewer.getControl());
    }
}

