/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SystemCursorType implements Enumerator
{
    ARROW(1, "ARROW", "ARROW"),
    HAND(0, "HAND", "HAND");

    public static final int ARROW_VALUE = 1;
    public static final int HAND_VALUE = 0;
    private static final SystemCursorType[] VALUES_ARRAY;
    public static final List<SystemCursorType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SystemCursorType[]{ARROW, HAND};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SystemCursorType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SystemCursorType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SystemCursorType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SystemCursorType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SystemCursorType get(int value) {
        switch (value) {
            case 1: {
                return ARROW;
            }
            case 0: {
                return HAND;
            }
        }
        return null;
    }

    private SystemCursorType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

