/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.importer.wizard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.scada.ca.data.DiffEntry;
import org.eclipse.scada.ca.ui.importer.wizard.DiffSubEntry;

public final class DiffEntryHelper {
    private DiffEntryHelper() {
    }

    public static Object[] diffChilds(DiffEntry entry) {
        Map<String, DiffSubEntry> childs = DiffEntryHelper.makeChilds(entry);
        ArrayList<DiffSubEntry> result = new ArrayList<DiffSubEntry>(childs.values());
        Collections.sort(result);
        return result.toArray();
    }

    public static Object diffChildsByIndex(DiffEntry entry, int index) {
        Map<String, DiffSubEntry> childs = DiffEntryHelper.makeChilds(entry);
        ArrayList<DiffSubEntry> result = new ArrayList<DiffSubEntry>(childs.values());
        Collections.sort(result);
        return result.get(index);
    }

    private static Map<String, DiffSubEntry> makeChilds(DiffEntry entry) {
        DiffSubEntry subEntry;
        LinkedHashMap<String, DiffSubEntry> childs = new LinkedHashMap<String, DiffSubEntry>();
        if (entry.getAddedOrUpdatedData() != null) {
            for (Map.Entry data : entry.getAddedOrUpdatedData().entrySet()) {
                subEntry = new DiffSubEntry(entry, (String)data.getKey());
                subEntry.setNewValue((String)data.getValue());
                childs.put((String)data.getKey(), subEntry);
            }
        }
        if (entry.getRemovedData() != null) {
            for (String removed : entry.getRemovedData()) {
                subEntry = new DiffSubEntry(entry, removed);
                subEntry.setNewValue(null);
                childs.put(removed, subEntry);
            }
        }
        if (entry.getOldData() != null) {
            for (Map.Entry data : entry.getOldData().entrySet()) {
                subEntry = (DiffSubEntry)childs.get(data.getKey());
                if (subEntry == null) {
                    subEntry = new DiffSubEntry(entry, (String)data.getKey());
                    childs.put((String)data.getKey(), subEntry);
                }
                subEntry.setOldValue((String)data.getValue());
            }
        }
        return childs;
    }
}

