/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.importer.wizard;

import java.util.Map;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scada.ca.data.DiffEntry;
import org.eclipse.scada.ca.ui.importer.wizard.DiffSubEntry;

public class DiffEntryLabelProvider
extends CellLabelProvider {
    private static final int MAX_STR_LENGTH = 200;

    public void update(ViewerCell cell) {
        Object ele = cell.getElement();
        if (ele instanceof DiffEntry) {
            DiffEntry entry = (DiffEntry)ele;
            int idx = cell.getColumnIndex();
            switch (idx) {
                case 0: {
                    cell.setText(entry.getFactoryId());
                    break;
                }
                case 1: {
                    cell.setText(entry.getConfigurationId());
                    break;
                }
                case 2: {
                    cell.setText(entry.getOperation().toString());
                    break;
                }
                case 3: {
                    cell.setText(this.formatData(entry.getAddedOrUpdatedData(), 200));
                    break;
                }
                case 4: {
                    cell.setText(this.formatData(entry.getOldData(), 200));
                }
            }
        } else if (ele instanceof DiffSubEntry) {
            DiffSubEntry entry = (DiffSubEntry)ele;
            int idx = cell.getColumnIndex();
            switch (idx) {
                case 0: {
                    break;
                }
                case 1: {
                    cell.setText(entry.getKey());
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    cell.setText(entry.getNewValue());
                    break;
                }
                case 4: {
                    cell.setText(entry.getOldValue());
                }
            }
        }
    }

    private String formatData(Map<String, String> data, int maxLen) {
        if (data == null) {
            return null;
        }
        String str = data.toString();
        if (maxLen > 0 && str.length() > maxLen) {
            return String.valueOf(str.substring(0, maxLen)) + "\u2026";
        }
        return str;
    }
}

