/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.importer.wizard;

import com.google.common.collect.Iterables;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.scada.ca.connection.provider.ConnectionService;
import org.eclipse.scada.ca.ui.importer.Activator;
import org.eclipse.scada.ca.ui.importer.wizard.IgnorePage;
import org.eclipse.scada.ca.ui.importer.wizard.LocalDataPage;
import org.eclipse.scada.ca.ui.importer.wizard.Messages;
import org.eclipse.scada.ca.ui.importer.wizard.PreviewPage;
import org.eclipse.scada.ca.ui.importer.wizard.RemoteDataPage;
import org.eclipse.scada.ca.ui.util.DiffController;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.ui.DisplayCallbackHandler;
import org.eclipse.scada.ui.databinding.AdapterHelper;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportWizard
extends Wizard
implements IImportWizard {
    private static final Logger logger = LoggerFactory.getLogger(ImportWizard.class);
    private ConnectionService connection;
    private final DiffController mergeController;

    public ImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.ImportWizard_Title);
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection("importWizard");
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection("importWizard");
        }
        this.setDialogSettings(Activator.getDefault().getDialogSettings().getSection("importWizard"));
        this.mergeController = new DiffController();
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ImportWizard.this.applyDiff(monitor);
                    }
                    catch (ExecutionException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            return true;
        }
        catch (Exception e) {
            logger.warn("Failed to import", (Throwable)e);
            StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.ca.ui.importer", (String)Messages.ImportWizard_StatusErrorFailedToApply, (Throwable)e), 4);
            return false;
        }
    }

    protected void applyDiff(IProgressMonitor parentMonitor) throws InterruptedException, ExecutionException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)parentMonitor, (int)100);
        monitor.setTaskName(Messages.ImportWizard_TaskName);
        List result = this.mergeController.merge((IProgressMonitor)monitor.newChild(10));
        if (result.isEmpty()) {
            monitor.done();
            return;
        }
        Iterable splitted = Iterables.partition((Iterable)result, (int)Activator.getDefault().getPreferenceStore().getInt("defaultChunkSize"));
        SubMonitor sub = monitor.newChild(90);
        try {
            int size = Iterables.size((Iterable)splitted);
            sub.beginTask(Messages.ImportWizard_TaskName, size);
            int pos = 0;
            for (Iterable i : splitted) {
                sub.subTask(String.format(Messages.ImportWizard_SubTaskName, pos, size));
                LinkedList entries = new LinkedList();
                Iterables.addAll(entries, (Iterable)i);
                NotifyFuture future = this.connection.getConnection().applyDiff(entries, null, (CallbackHandler)new DisplayCallbackHandler(this.getShell(), "Apply diff", "Confirmation for applying diff is required"));
                future.get();
                ++pos;
                sub.worked(1);
            }
        }
        finally {
            sub.done();
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)new LocalDataPage(this.connection, this.mergeController));
        this.addPage((IWizardPage)new RemoteDataPage(this.connection, this.mergeController));
        this.addPage((IWizardPage)new IgnorePage(this.mergeController));
        this.addPage((IWizardPage)new PreviewPage(this.mergeController));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.connection = this.getConnection(selection);
    }

    private ConnectionService getConnection(IStructuredSelection selection) {
        if (selection == null) {
            return null;
        }
        Object o = AdapterHelper.adapt((Object)selection.getFirstElement(), org.eclipse.scada.core.connection.provider.ConnectionService.class);
        if (o instanceof ConnectionService) {
            return (ConnectionService)o;
        }
        return null;
    }
}

