/*******************************************************************************
 * Copyright (c) 2012, 2013 TH4 SYSTEMS GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     TH4 SYSTEMS GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.scada.vi.details.model.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.scada.vi.details.model.DetailViewPackage;
import org.eclipse.scada.vi.details.model.util.DetailViewAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class DetailViewItemProviderAdapterFactory extends DetailViewAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender
{
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier ();

    /**
     * This helps manage the child creation extenders.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager ( DetailViewEditPlugin.INSTANCE, DetailViewPackage.eNS_URI );

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object> ();

    /**
     * This constructs an instance.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public DetailViewItemProviderAdapterFactory ()
    {
        supportedTypes.add ( IEditingDomainItemProvider.class );
        supportedTypes.add ( IStructuredItemContentProvider.class );
        supportedTypes.add ( ITreeItemContentProvider.class );
        supportedTypes.add ( IItemLabelProvider.class );
        supportedTypes.add ( IItemPropertySource.class );
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.View} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ViewItemProvider viewItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.View}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createViewAdapter ()
    {
        if ( viewItemProvider == null )
        {
            viewItemProvider = new ViewItemProvider ( this );
        }

        return viewItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.GroupEntry} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GroupEntryItemProvider groupEntryItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.GroupEntry}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createGroupEntryAdapter ()
    {
        if ( groupEntryItemProvider == null )
        {
            groupEntryItemProvider = new GroupEntryItemProvider ( this );
        }

        return groupEntryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.LabelComponent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected LabelComponentItemProvider labelComponentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.LabelComponent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createLabelComponentAdapter ()
    {
        if ( labelComponentItemProvider == null )
        {
            labelComponentItemProvider = new LabelComponentItemProvider ( this );
        }

        return labelComponentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.FillLayoutComponent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected FillLayoutComponentItemProvider fillLayoutComponentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.FillLayoutComponent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createFillLayoutComponentAdapter ()
    {
        if ( fillLayoutComponentItemProvider == null )
        {
            fillLayoutComponentItemProvider = new FillLayoutComponentItemProvider ( this );
        }

        return fillLayoutComponentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.ButtonComponent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ButtonComponentItemProvider buttonComponentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.ButtonComponent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createButtonComponentAdapter ()
    {
        if ( buttonComponentItemProvider == null )
        {
            buttonComponentItemProvider = new ButtonComponentItemProvider ( this );
        }

        return buttonComponentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.BoolLEDComponent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected BoolLEDComponentItemProvider boolLEDComponentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.BoolLEDComponent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createBoolLEDComponentAdapter ()
    {
        if ( boolLEDComponentItemProvider == null )
        {
            boolLEDComponentItemProvider = new BoolLEDComponentItemProvider ( this );
        }

        return boolLEDComponentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.ItemValueSource} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ItemValueSourceItemProvider itemValueSourceItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.ItemValueSource}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createItemValueSourceAdapter ()
    {
        if ( itemValueSourceItemProvider == null )
        {
            itemValueSourceItemProvider = new ItemValueSourceItemProvider ( this );
        }

        return itemValueSourceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.NotTransformer} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected NotTransformerItemProvider notTransformerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.NotTransformer}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createNotTransformerAdapter ()
    {
        if ( notTransformerItemProvider == null )
        {
            notTransformerItemProvider = new NotTransformerItemProvider ( this );
        }

        return notTransformerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.Registration} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected RegistrationItemProvider registrationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.Registration}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createRegistrationAdapter ()
    {
        if ( registrationItemProvider == null )
        {
            registrationItemProvider = new RegistrationItemProvider ( this );
        }

        return registrationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.SimpleGridComponent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SimpleGridComponentItemProvider simpleGridComponentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.SimpleGridComponent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSimpleGridComponentAdapter ()
    {
        if ( simpleGridComponentItemProvider == null )
        {
            simpleGridComponentItemProvider = new SimpleGridComponentItemProvider ( this );
        }

        return simpleGridComponentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.GroupGridComponent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GroupGridComponentItemProvider groupGridComponentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.GroupGridComponent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createGroupGridComponentAdapter ()
    {
        if ( groupGridComponentItemProvider == null )
        {
            groupGridComponentItemProvider = new GroupGridComponentItemProvider ( this );
        }

        return groupGridComponentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.GroupGridEntry} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GroupGridEntryItemProvider groupGridEntryItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.GroupGridEntry}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createGroupGridEntryAdapter ()
    {
        if ( groupGridEntryItemProvider == null )
        {
            groupGridEntryItemProvider = new GroupGridEntryItemProvider ( this );
        }

        return groupGridEntryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.ValueSetComponent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ValueSetComponentItemProvider valueSetComponentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.ValueSetComponent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createValueSetComponentAdapter ()
    {
        if ( valueSetComponentItemProvider == null )
        {
            valueSetComponentItemProvider = new ValueSetComponentItemProvider ( this );
        }

        return valueSetComponentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.ValueComponent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ValueComponentItemProvider valueComponentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.ValueComponent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createValueComponentAdapter ()
    {
        if ( valueComponentItemProvider == null )
        {
            valueComponentItemProvider = new ValueComponentItemProvider ( this );
        }

        return valueComponentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.AndTransformer} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AndTransformerItemProvider andTransformerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.AndTransformer}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createAndTransformerAdapter ()
    {
        if ( andTransformerItemProvider == null )
        {
            andTransformerItemProvider = new AndTransformerItemProvider ( this );
        }

        return andTransformerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.OrTransformer} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected OrTransformerItemProvider orTransformerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.OrTransformer}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createOrTransformerAdapter ()
    {
        if ( orTransformerItemProvider == null )
        {
            orTransformerItemProvider = new OrTransformerItemProvider ( this );
        }

        return orTransformerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.TextInputComponent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TextInputComponentItemProvider textInputComponentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.TextInputComponent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createTextInputComponentAdapter ()
    {
        if ( textInputComponentItemProvider == null )
        {
            textInputComponentItemProvider = new TextInputComponentItemProvider ( this );
        }

        return textInputComponentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.TextComponent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TextComponentItemProvider textComponentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.TextComponent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createTextComponentAdapter ()
    {
        if ( textComponentItemProvider == null )
        {
            textComponentItemProvider = new TextComponentItemProvider ( this );
        }

        return textComponentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.TextInputMultiComponent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TextInputMultiComponentItemProvider textInputMultiComponentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.TextInputMultiComponent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createTextInputMultiComponentAdapter ()
    {
        if ( textInputMultiComponentItemProvider == null )
        {
            textInputMultiComponentItemProvider = new TextInputMultiComponentItemProvider ( this );
        }

        return textInputMultiComponentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.CheckComponent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CheckComponentItemProvider checkComponentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.CheckComponent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCheckComponentAdapter ()
    {
        if ( checkComponentItemProvider == null )
        {
            checkComponentItemProvider = new CheckComponentItemProvider ( this );
        }

        return checkComponentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.LinkComponent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected LinkComponentItemProvider linkComponentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.LinkComponent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createLinkComponentAdapter ()
    {
        if ( linkComponentItemProvider == null )
        {
            linkComponentItemProvider = new LinkComponentItemProvider ( this );
        }

        return linkComponentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.URLImageComponent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected URLImageComponentItemProvider urlImageComponentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.URLImageComponent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createURLImageComponentAdapter ()
    {
        if ( urlImageComponentItemProvider == null )
        {
            urlImageComponentItemProvider = new URLImageComponentItemProvider ( this );
        }

        return urlImageComponentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.ProgressComponent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ProgressComponentItemProvider progressComponentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.ProgressComponent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createProgressComponentAdapter ()
    {
        if ( progressComponentItemProvider == null )
        {
            progressComponentItemProvider = new ProgressComponentItemProvider ( this );
        }

        return progressComponentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.HiddenComponent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected HiddenComponentItemProvider hiddenComponentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.HiddenComponent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createHiddenComponentAdapter ()
    {
        if ( hiddenComponentItemProvider == null )
        {
            hiddenComponentItemProvider = new HiddenComponentItemProvider ( this );
        }

        return hiddenComponentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.ScriptVisibility} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ScriptVisibilityItemProvider scriptVisibilityItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.ScriptVisibility}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createScriptVisibilityAdapter ()
    {
        if ( scriptVisibilityItemProvider == null )
        {
            scriptVisibilityItemProvider = new ScriptVisibilityItemProvider ( this );
        }

        return scriptVisibilityItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.PermissionVisibility} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected PermissionVisibilityItemProvider permissionVisibilityItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.PermissionVisibility}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createPermissionVisibilityAdapter ()
    {
        if ( permissionVisibilityItemProvider == null )
        {
            permissionVisibilityItemProvider = new PermissionVisibilityItemProvider ( this );
        }

        return permissionVisibilityItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.Invisible} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected InvisibleItemProvider invisibleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.Invisible}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createInvisibleAdapter ()
    {
        if ( invisibleItemProvider == null )
        {
            invisibleItemProvider = new InvisibleItemProvider ( this );
        }

        return invisibleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.TestVisibility} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TestVisibilityItemProvider testVisibilityItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.TestVisibility}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createTestVisibilityAdapter ()
    {
        if ( testVisibilityItemProvider == null )
        {
            testVisibilityItemProvider = new TestVisibilityItemProvider ( this );
        }

        return testVisibilityItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.vi.details.model.ScriptModule} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ScriptModuleItemProvider scriptModuleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.vi.details.model.ScriptModule}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createScriptModuleAdapter ()
    {
        if ( scriptModuleItemProvider == null )
        {
            scriptModuleItemProvider = new ScriptModuleItemProvider ( this );
        }

        return scriptModuleItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ComposeableAdapterFactory getRootAdapterFactory ()
    {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory ();
    }

    /**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setParentAdapterFactory ( ComposedAdapterFactory parentAdapterFactory )
    {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean isFactoryForType ( Object type )
    {
        return supportedTypes.contains ( type ) || super.isFactoryForType ( type );
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter adapt ( Notifier notifier, Object type )
    {
        return super.adapt ( notifier, this );
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object adapt ( Object object, Object type )
    {
        if ( isFactoryForType ( type ) )
        {
            Object adapter = super.adapt ( object, type );
            if ( ! ( type instanceof Class<?> ) || ( ( (Class<?>)type ).isInstance ( adapter ) ) )
            {
                return adapter;
            }
        }

        return null;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public List<IChildCreationExtender> getChildCreationExtenders ()
    {
        return childCreationExtenderManager.getChildCreationExtenders ();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Collection<?> getNewChildDescriptors ( Object object, EditingDomain editingDomain )
    {
        return childCreationExtenderManager.getNewChildDescriptors ( object, editingDomain );
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ResourceLocator getResourceLocator ()
    {
        return childCreationExtenderManager;
    }

    /**
     * This adds a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void addListener ( INotifyChangedListener notifyChangedListener )
    {
        changeNotifier.addListener ( notifyChangedListener );
    }

    /**
     * This removes a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void removeListener ( INotifyChangedListener notifyChangedListener )
    {
        changeNotifier.removeListener ( notifyChangedListener );
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void fireNotifyChanged ( Notification notification )
    {
        changeNotifier.fireNotifyChanged ( notification );

        if ( parentAdapterFactory != null )
        {
            parentAdapterFactory.fireNotifyChanged ( notification );
        }
    }

    /**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void dispose ()
    {
        if ( viewItemProvider != null )
            viewItemProvider.dispose ();
        if ( groupEntryItemProvider != null )
            groupEntryItemProvider.dispose ();
        if ( labelComponentItemProvider != null )
            labelComponentItemProvider.dispose ();
        if ( fillLayoutComponentItemProvider != null )
            fillLayoutComponentItemProvider.dispose ();
        if ( buttonComponentItemProvider != null )
            buttonComponentItemProvider.dispose ();
        if ( boolLEDComponentItemProvider != null )
            boolLEDComponentItemProvider.dispose ();
        if ( itemValueSourceItemProvider != null )
            itemValueSourceItemProvider.dispose ();
        if ( notTransformerItemProvider != null )
            notTransformerItemProvider.dispose ();
        if ( registrationItemProvider != null )
            registrationItemProvider.dispose ();
        if ( simpleGridComponentItemProvider != null )
            simpleGridComponentItemProvider.dispose ();
        if ( groupGridComponentItemProvider != null )
            groupGridComponentItemProvider.dispose ();
        if ( groupGridEntryItemProvider != null )
            groupGridEntryItemProvider.dispose ();
        if ( valueSetComponentItemProvider != null )
            valueSetComponentItemProvider.dispose ();
        if ( valueComponentItemProvider != null )
            valueComponentItemProvider.dispose ();
        if ( andTransformerItemProvider != null )
            andTransformerItemProvider.dispose ();
        if ( orTransformerItemProvider != null )
            orTransformerItemProvider.dispose ();
        if ( textInputComponentItemProvider != null )
            textInputComponentItemProvider.dispose ();
        if ( textComponentItemProvider != null )
            textComponentItemProvider.dispose ();
        if ( textInputMultiComponentItemProvider != null )
            textInputMultiComponentItemProvider.dispose ();
        if ( checkComponentItemProvider != null )
            checkComponentItemProvider.dispose ();
        if ( linkComponentItemProvider != null )
            linkComponentItemProvider.dispose ();
        if ( urlImageComponentItemProvider != null )
            urlImageComponentItemProvider.dispose ();
        if ( progressComponentItemProvider != null )
            progressComponentItemProvider.dispose ();
        if ( hiddenComponentItemProvider != null )
            hiddenComponentItemProvider.dispose ();
        if ( scriptVisibilityItemProvider != null )
            scriptVisibilityItemProvider.dispose ();
        if ( permissionVisibilityItemProvider != null )
            permissionVisibilityItemProvider.dispose ();
        if ( invisibleItemProvider != null )
            invisibleItemProvider.dispose ();
        if ( testVisibilityItemProvider != null )
            testVisibilityItemProvider.dispose ();
        if ( scriptModuleItemProvider != null )
            scriptModuleItemProvider.dispose ();
    }

}
