/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.importer.wizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scada.ca.client.Connection;
import org.eclipse.scada.ca.connection.provider.ConnectionService;
import org.eclipse.scada.ca.data.FactoryInformation;
import org.eclipse.scada.ca.oscar.OscarLoader;
import org.eclipse.scada.ca.ui.importer.wizard.Messages;
import org.eclipse.scada.ca.ui.util.ConfigurationHelper;
import org.eclipse.scada.ca.ui.util.DiffController;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.statushandlers.StatusManager;

public class RemoteDataPage
extends WizardPage {
    private final ConnectionService service;
    private Label resultText;
    private final DiffController mergeController;
    private long count;

    public RemoteDataPage(ConnectionService service, DiffController mergeController) {
        super("loadPage");
        this.setTitle(Messages.RemoteDataPage_Title);
        this.service = service;
        this.mergeController = mergeController;
    }

    public void createControl(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new GridLayout(1, false));
        Button loadButton = new Button(wrapper, 8);
        loadButton.setText(Messages.RemoteDataPage_LoadButtonText);
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteDataPage.this.performLoad();
            }
        });
        Button loadLocalButton = new Button(wrapper, 8);
        loadLocalButton.setText(Messages.RemoteDataPage_ButtonLocalFile);
        loadLocalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteDataPage.this.handleLoadLocal();
            }
        });
        this.resultText = new Label(wrapper, 0);
        this.resultText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.setControl((Control)wrapper);
        this.update();
    }

    protected void handleLoadLocal() {
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        dlg.setFilterExtensions(new String[]{"*.oscar", "*.json", "*.*"});
        dlg.setFilterNames(new String[]{Messages.LocalDataPage_OSCARFilterDescription, Messages.LocalDataPage_JSONFilterDescription, Messages.LocalDataPage_AllFilterDescription});
        String selectedFileName = this.getWizard().getDialogSettings().get("localDataPage.file");
        if (selectedFileName != null && selectedFileName.length() > 0) {
            dlg.setFileName(selectedFileName);
        }
        dlg.setFilterIndex(0);
        String file = dlg.open();
        if (file != null) {
            this.getWizard().getDialogSettings().put("localDataPage.file", file);
            this.loadFromLocalFile(file);
        }
    }

    private void loadFromLocalFile(final String file) {
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Map data;
                    File localFile = new File(file);
                    try {
                        try {
                            monitor.beginTask(Messages.RemoteDataPage_TaskName, -1);
                            data = OscarLoader.isOscar((File)localFile) ? new OscarLoader(localFile).getData() : OscarLoader.loadJsonData((InputStream)new FileInputStream(file));
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    RemoteDataPage.this.mergeController.setRemoteData(data);
                    RemoteDataPage.this.count = RemoteDataPage.count(data);
                }
            });
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.scada.ca.ui.importer", Messages.RemoteDataPage_StatusText, (Throwable)e));
        }
        this.update();
    }

    protected static long count(Map<String, Map<String, Map<String, String>>> data) {
        long count = 0L;
        for (Map.Entry<String, Map<String, Map<String, String>>> entry : data.entrySet()) {
            count += (long)entry.getValue().size();
        }
        return count;
    }

    protected void performLoad() {
        final AtomicReference result = new AtomicReference();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        result.set(RemoteDataPage.this.loadData(monitor));
                    }
                    catch (ExecutionException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            this.setResult((Collection)result.get());
        }
        catch (InvocationTargetException e) {
            this.setError(String.valueOf(Messages.RemoteDataPage_FailedToLoadMessage) + e.getMessage());
        }
        catch (InterruptedException e) {
            this.setError(String.valueOf(Messages.RemoteDataPage_FailedToLoadMessage) + e.getMessage());
        }
    }

    private void setResult(Collection<FactoryInformation> result) {
        this.count = this.mergeController.setRemoteData(result);
        this.update();
    }

    private Collection<FactoryInformation> loadData(IProgressMonitor monitor) throws InterruptedException, ExecutionException {
        return ConfigurationHelper.loadData((IProgressMonitor)monitor, (Connection)this.service.getConnection());
    }

    private void update() {
        if (this.service == null) {
            this.setError(Messages.RemoteDataPage_ErrorNoService);
        } else if (this.service.getConnection() == null) {
            this.setError(Messages.RemoteDataPage_ErrorNoConnection);
        } else if (this.mergeController.getRemoteData() == null) {
            this.setError(Messages.RemoteDataPage_ErrorNoData);
        } else {
            this.setErrorMessage(null);
            this.setDescription(Messages.RemoteDataPage_MessageDataLoaded);
            this.setPageComplete(true);
        }
        if (this.mergeController.getRemoteData() != null) {
            this.resultText.setText(String.format(Messages.RemoteDataPage_StatusLabelFormat, this.mergeController.getRemoteData().size(), this.count));
        } else {
            this.resultText.setText(Messages.RemoteDataPage_StatusLabelNoData);
        }
    }

    private void setError(String string) {
        this.setPageComplete(string == null);
        if (string == null) {
            this.setDescription(Messages.RemoteDataPage_DescriptionText);
        } else {
            this.setErrorMessage(string);
        }
    }
}

