/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.client.test.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.da.ui.client.test.console.CommandContext;
import org.eclipse.scada.da.ui.client.test.console.CommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandProcessorImpl {
    private static final Logger logger = LoggerFactory.getLogger(CommandProcessorImpl.class);
    private final Map<String, CommandHandler> commands = new HashMap<String, CommandHandler>();
    private final PrintStream output;
    private final PrintStream error;
    private Thread reader;
    private final InputStream input;

    public CommandProcessorImpl(String name, InputStream input, OutputStream output, OutputStream error) {
        this.output = new PrintStream(output);
        this.error = new PrintStream(error);
        this.input = input;
        this.reader = new Thread("ConsoleReader - " + name){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CommandProcessorImpl.this.runReader();
                }
                catch (Exception e) {
                    CommandProcessorImpl commandProcessorImpl = CommandProcessorImpl.this;
                    synchronized (commandProcessorImpl) {
                        logger.debug("Reader thread died", (Throwable)e);
                        CommandProcessorImpl.this.reader = null;
                    }
                }
            }
        };
        this.reader.start();
    }

    public void addCommand(String name, CommandHandler command) {
        this.commands.put(name, command);
    }

    public synchronized void dispose() {
        this.output.close();
        this.error.close();
        try {
            this.input.close();
        }
        catch (IOException iOException) {}
        if (this.reader != null) {
            try {
                this.reader.join();
            }
            catch (InterruptedException interruptedException) {}
            this.reader = null;
        }
    }

    protected void runReader() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.input, Charset.forName("UTF-8")));
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.processLine(line);
            }
        }
        catch (Throwable throwable) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
    }

    protected void processLine(String line) {
        String[] toks = line.split("\\s+", 2);
        if (toks.length < 1) {
            return;
        }
        CommandHandler command = this.commands.get(toks[0]);
        if (command == null) {
            this.error.printf("Command '%s' is unknown", toks[0]);
            this.error.println();
            return;
        }
        try {
            command.runCommand(new CommandContext(){

                @Override
                public PrintStream getOutputStream() {
                    return CommandProcessorImpl.this.output;
                }

                @Override
                public PrintStream getErrorStream() {
                    return CommandProcessorImpl.this.error;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace(this.error);
        }
    }
}

