/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.ui.chart.model.XAxis;
import org.eclipse.scada.ui.chart.viewer.AbstractAxisManager;
import org.eclipse.scada.ui.chart.viewer.XAxisViewer;

public class XAxisManager
extends AbstractAxisManager<XAxis, XAxisViewer> {
    private final Map<XAxis, XAxisViewer> axisMap = new HashMap<XAxis, XAxisViewer>(1);
    private final boolean top;

    public XAxisManager(DataBindingContext dbc, ChartRenderer manager, boolean top) {
        super(dbc, manager);
        this.top = top;
    }

    @Override
    protected void handleAdd(int index, XAxis axis) {
        XAxisViewer viewer = new XAxisViewer(this.dbc, this.manager, axis, this.top);
        this.axisMap.put(axis, viewer);
    }

    @Override
    protected void handleRemove(XAxis axis) {
        XAxisViewer viewer = this.axisMap.remove(axis);
        if (viewer != null) {
            viewer.dispose();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        for (XAxisViewer viewer : this.axisMap.values()) {
            viewer.dispose();
        }
        this.axisMap.clear();
    }

    @Override
    public XAxisViewer getAxis(XAxis axis) {
        return this.axisMap.get(axis);
    }

    @Override
    public Collection<XAxisViewer> getAll() {
        return this.axisMap.values();
    }
}

