/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.controller.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.ui.chart.model.ChartPackage;
import org.eclipse.scada.ui.chart.model.CurrentTimeController;
import org.eclipse.scada.ui.chart.model.XAxisController;
import org.eclipse.scada.ui.chart.viewer.ChartContext;
import org.eclipse.scada.ui.chart.viewer.XAxisViewer;
import org.eclipse.scada.ui.chart.viewer.controller.ChartController;
import org.eclipse.scada.ui.chart.viewer.controller.actions.AbstractXAxisController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentTimeChartController
extends AbstractXAxisController
implements ChartController {
    private static final Logger logger = LoggerFactory.getLogger(CurrentTimeChartController.class);
    private long milliseconds;
    private Long timespan;
    private final Realm realm;
    private boolean disposed;
    private String alignDateFormat;

    public CurrentTimeChartController(DataBindingContext ctx, Realm realm, CurrentTimeController controller, ChartContext chartContext) {
        super(ctx, chartContext, (XAxisController)controller);
        this.realm = realm;
        this.addBinding(ctx.bindValue(PojoObservables.observeValue((Object)this, (String)"milliseconds"), EMFObservables.observeValue((EObject)controller, (EStructuralFeature)ChartPackage.Literals.CURRENT_TIME_CONTROLLER__DIFF)));
        this.addBinding(ctx.bindValue(PojoObservables.observeValue((Object)this, (String)"timespan"), EMFObservables.observeValue((EObject)controller, (EStructuralFeature)ChartPackage.Literals.CURRENT_TIME_CONTROLLER__TIMESPAN)));
        this.addBinding(ctx.bindValue(PojoObservables.observeValue((Object)this, (String)"alignDateFormat"), EMFObservables.observeValue((EObject)controller, (EStructuralFeature)ChartPackage.Literals.CURRENT_TIME_CONTROLLER__ALIGN_DATE_FORMAT)));
        this.tick();
    }

    public void setAlignDateFormat(String alignDateFormat) {
        this.alignDateFormat = alignDateFormat;
    }

    public String getAlignDateFormat() {
        return this.alignDateFormat;
    }

    protected void startTimer() {
        if (this.disposed) {
            return;
        }
        this.realm.timerExec(1000, new Runnable(){

            @Override
            public void run() {
                CurrentTimeChartController.this.tick();
            }
        });
    }

    protected void tick() {
        if (this.disposed) {
            return;
        }
        this.handleTick();
        this.startTimer();
    }

    protected void handleTick() {
        long now = System.currentTimeMillis();
        for (XAxisViewer viewer : this.getCurrentViewers()) {
            this.update(now, viewer);
        }
    }

    private void update(long now, XAxisViewer viewer) {
        now += this.milliseconds;
        if (this.alignDateFormat != null && !this.alignDateFormat.isEmpty()) {
            Date date;
            SimpleDateFormat df = new SimpleDateFormat(this.alignDateFormat);
            try {
                date = df.parse(df.format(new Date(now)));
            }
            catch (ParseException e) {
                logger.warn("Failed to update chart axis", (Throwable)e);
                return;
            }
            now = date.getTime();
        }
        if (viewer == null) {
            return;
        }
        XAxis axis = viewer.getAxis();
        if (axis == null) {
            return;
        }
        if (this.timespan != null) {
            axis.setMinMax(now, now + this.timespan);
        } else {
            axis.setStartTimestamp(now);
        }
    }

    public void setMilliseconds(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }

    public void setTimespan(Long timespan) {
        this.timespan = timespan;
    }

    public Long getTimespan() {
        return this.timespan;
    }

    @Override
    public void dispose() {
        this.disposed = true;
        super.dispose();
    }
}

