/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.connection.data;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.scada.da.client.DataItem;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.connection.provider.ConnectionService;
import org.eclipse.scada.da.ui.connection.data.AbstractItemHolder;
import org.eclipse.scada.da.ui.connection.data.DataSourceListener;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.osgi.framework.BundleContext;

public class DataItemHolder
extends AbstractItemHolder {
    private DataItem dataItem;
    private final Observer observer;
    private final DataSourceListener listener;

    public DataItemHolder(BundleContext context, Item item, DataSourceListener listener) {
        super(context, item, null);
        this.listener = listener;
        this.observer = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                DataItemHolder.this.update(o, arg);
            }
        };
        this.init();
    }

    protected void update(Observable o, Object arg) {
        if (o != this.dataItem) {
            return;
        }
        if (!(arg instanceof DataItemValue)) {
            return;
        }
        this.fireListenerChange((DataItemValue)arg);
    }

    protected void fireListenerChange(DataItemValue value) {
        if (this.listener != null) {
            this.listener.updateData(value);
        }
    }

    @Override
    protected synchronized void bindConnection(ConnectionService connectionService) {
        super.bindConnection(connectionService);
        if (connectionService != null) {
            this.dataItem = new DataItem(this.item.getId());
            this.dataItem.addObserver(this.observer);
            this.dataItem.register(connectionService.getItemManager());
        }
    }

    @Override
    protected synchronized void unbindConnection() {
        super.unbindConnection();
        if (this.dataItem != null) {
            this.dataItem.deleteObserver(this.observer);
            this.dataItem.unregister();
            this.dataItem = null;
        }
        this.fireListenerChange(null);
    }
}

