/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.commands;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.scada.core.ui.connection.ConnectionStore;
import org.eclipse.scada.core.ui.connection.commands.AbstractConnectionHandler;
import org.eclipse.scada.core.ui.connection.commands.Messages;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;
import org.eclipse.scada.ui.databinding.AdapterHelper;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteConnection
extends AbstractConnectionHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteConnection.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        logger.info("Execute command: {}", (Object)event);
        Collection<ConnectionHolder> connections = this.getConnections();
        boolean result = MessageDialog.openQuestion((Shell)this.getWorkbenchWindow().getShell(), (String)Messages.DeleteConnection_MessageDialog_Title, (String)MessageFormat.format(Messages.DeleteConnection_MessageDialog_Message, connections.size()));
        if (!result) {
            return null;
        }
        MultiStatus status = new MultiStatus("org.eclipse.scada.core.ui.connection", 0, Messages.DeleteConnection_MultiStatus_Text, null);
        for (ConnectionHolder holder : connections) {
            ConnectionStore store = (ConnectionStore)AdapterHelper.adapt((Object)holder.getDiscoverer(), ConnectionStore.class);
            if (store == null) continue;
            try {
                store.remove(holder.getConnectionInformation());
            }
            catch (CoreException e) {
                logger.info("Failed to remove connection", (Throwable)e);
                status.add(e.getStatus());
            }
        }
        return null;
    }
}

